<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The Gelukt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Gelukt;
    /**
     * The Bericht
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Bericht;
    /**
     * The SD_InstroomkanaalID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SD_InstroomkanaalID;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Omschrijving
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Omschrijving;
    /**
     * The Waarde
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Waarde;
    /**
     * The _Actief
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_Actief;
    /**
     * The SorteerVolgorde
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SorteerVolgorde;
    /**
     * Constructor method for Result
     * @uses Result::setGelukt()
     * @uses Result::setBericht()
     * @uses Result::setSD_InstroomkanaalID()
     * @uses Result::setCode()
     * @uses Result::setOmschrijving()
     * @uses Result::setWaarde()
     * @uses Result::set_Actief()
     * @uses Result::setSorteerVolgorde()
     * @param bool $gelukt
     * @param string $bericht
     * @param int $sD_InstroomkanaalID
     * @param int $code
     * @param string $omschrijving
     * @param int $waarde
     * @param bool $_Actief
     * @param int $sorteerVolgorde
     */
    public function __construct($gelukt = null, $bericht = null, $sD_InstroomkanaalID = null, $code = null, $omschrijving = null, $waarde = null, $_Actief = null, $sorteerVolgorde = null)
    {
        $this
            ->setGelukt($gelukt)
            ->setBericht($bericht)
            ->setSD_InstroomkanaalID($sD_InstroomkanaalID)
            ->setCode($code)
            ->setOmschrijving($omschrijving)
            ->setWaarde($waarde)
            ->set_Actief($_Actief)
            ->setSorteerVolgorde($sorteerVolgorde);
    }
    /**
     * Get Gelukt value
     * @return bool|null
     */
    public function getGelukt()
    {
        return $this->Gelukt;
    }
    /**
     * Set Gelukt value
     * @param bool $gelukt
     * @return \StructType\Result
     */
    public function setGelukt($gelukt = null)
    {
        // validation for constraint: boolean
        if (!is_null($gelukt) && !is_bool($gelukt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gelukt)), __LINE__);
        }
        $this->Gelukt = $gelukt;
        return $this;
    }
    /**
     * Get Bericht value
     * @return string|null
     */
    public function getBericht()
    {
        return $this->Bericht;
    }
    /**
     * Set Bericht value
     * @param string $bericht
     * @return \StructType\Result
     */
    public function setBericht($bericht = null)
    {
        // validation for constraint: string
        if (!is_null($bericht) && !is_string($bericht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bericht)), __LINE__);
        }
        $this->Bericht = $bericht;
        return $this;
    }
    /**
     * Get SD_InstroomkanaalID value
     * @return int|null
     */
    public function getSD_InstroomkanaalID()
    {
        return $this->SD_InstroomkanaalID;
    }
    /**
     * Set SD_InstroomkanaalID value
     * @param int $sD_InstroomkanaalID
     * @return \StructType\Result
     */
    public function setSD_InstroomkanaalID($sD_InstroomkanaalID = null)
    {
        // validation for constraint: int
        if (!is_null($sD_InstroomkanaalID) && !is_numeric($sD_InstroomkanaalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sD_InstroomkanaalID)), __LINE__);
        }
        $this->SD_InstroomkanaalID = $sD_InstroomkanaalID;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\Result
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Omschrijving value
     * @return string|null
     */
    public function getOmschrijving()
    {
        return $this->Omschrijving;
    }
    /**
     * Set Omschrijving value
     * @param string $omschrijving
     * @return \StructType\Result
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 200) || (is_array($omschrijving) && count($omschrijving) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->Omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get Waarde value
     * @return int|null
     */
    public function getWaarde()
    {
        return $this->Waarde;
    }
    /**
     * Set Waarde value
     * @param int $waarde
     * @return \StructType\Result
     */
    public function setWaarde($waarde = null)
    {
        // validation for constraint: int
        if (!is_null($waarde) && !is_numeric($waarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($waarde)), __LINE__);
        }
        $this->Waarde = $waarde;
        return $this;
    }
    /**
     * Get _Actief value
     * @return bool|null
     */
    public function get_Actief()
    {
        return $this->_Actief;
    }
    /**
     * Set _Actief value
     * @param bool $_Actief
     * @return \StructType\Result
     */
    public function set_Actief($_Actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($_Actief) && !is_bool($_Actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_Actief)), __LINE__);
        }
        $this->_Actief = $_Actief;
        return $this;
    }
    /**
     * Get SorteerVolgorde value
     * @return int|null
     */
    public function getSorteerVolgorde()
    {
        return $this->SorteerVolgorde;
    }
    /**
     * Set SorteerVolgorde value
     * @param int $sorteerVolgorde
     * @return \StructType\Result
     */
    public function setSorteerVolgorde($sorteerVolgorde = null)
    {
        // validation for constraint: int
        if (!is_null($sorteerVolgorde) && !is_numeric($sorteerVolgorde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sorteerVolgorde)), __LINE__);
        }
        $this->SorteerVolgorde = $sorteerVolgorde;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
