<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedewerkerTemp StructType
 * @subpackage Structs
 */
class MedewerkerTemp extends AbstractStructBase
{
    /**
     * The Achternaam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 133
     * @var string
     */
    public $Achternaam;
    /**
     * The EmailadresPrive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $EmailadresPrive;
    /**
     * The EmailadresWerk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $EmailadresWerk;
    /**
     * The GeboorteDatum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeboorteDatum;
    /**
     * The Geboortenaam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $Geboortenaam;
    /**
     * The GeboortePlaats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $GeboortePlaats;
    /**
     * The Geslacht
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Geslacht;
    /**
     * The OpmerkingenInteresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpmerkingenInteresses;
    /**
     * The OpmerkingenMotivatie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpmerkingenMotivatie;
    /**
     * The OpmerkingenOpleiding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpmerkingenOpleiding;
    /**
     * The OpmerkingenWerkervaring
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpmerkingenWerkervaring;
    /**
     * The Plaats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $Plaats;
    /**
     * The StraatInclNummer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $StraatInclNummer;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $Postcode;
    /**
     * The Roepnaam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $Roepnaam;
    /**
     * The TelefoonVast
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $TelefoonVast;
    /**
     * The TelefoonMobiel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $TelefoonMobiel;
    /**
     * The TelefoonWerk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $TelefoonWerk;
    /**
     * The Voorletters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $Voorletters;
    /**
     * The Voornaam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $Voornaam;
    /**
     * The Voorvoegsels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $Voorvoegsels;
    /**
     * The _InterneSollicitatie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_InterneSollicitatie;
    /**
     * The _Mobiliteitskandidaat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_Mobiliteitskandidaat;
    /**
     * The VacatureNummer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 200
     * @var string
     */
    public $VacatureNummer;
    /**
     * The Code_Wervingskanaal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Code_Wervingskanaal;
    /**
     * The Code_Opleidingsniveau
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Code_Opleidingsniveau;
    /**
     * The Code_Werkervaring
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Code_Werkervaring;
    /**
     * The SD_Criteria_NP_MedewerkerTemp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SD_Criteria_NP_MedewerkerTemp
     */
    public $SD_Criteria_NP_MedewerkerTemp;
    /**
     * The Base64Decode_CV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Base64Decode_CV;
    /**
     * The Base64Decode_Motivatiebrief
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Base64Decode_Motivatiebrief;
    /**
     * The Base64Decode_ExtraBijlage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Base64Decode_ExtraBijlage;
    /**
     * The Bestandsnaam_CV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $Bestandsnaam_CV;
    /**
     * The Bestandsnaam_Motivatiebrief
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $Bestandsnaam_Motivatiebrief;
    /**
     * The Bestandsnaam_ExtraBijlage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 500
     * @var string
     */
    public $Bestandsnaam_ExtraBijlage;
    /**
     * The _OpenSollicitatie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_OpenSollicitatie;
    /**
     * The LinkedIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $LinkedIn;
    /**
     * The Twitter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $Twitter;
    /**
     * The _StopzettenJobalert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $_StopzettenJobalert;
    /**
     * The SD_Kenmerk2_NP_MedewerkerTemp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SD_Kenmerk2_NP_MedewerkerTemp
     */
    public $SD_Kenmerk2_NP_MedewerkerTemp;
    /**
     * The SD_Kenmerk1_NP_MedewerkerTemp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SD_Kenmerk1_NP_MedewerkerTemp
     */
    public $SD_Kenmerk1_NP_MedewerkerTemp;
    /**
     * Constructor method for MedewerkerTemp
     * @uses MedewerkerTemp::setAchternaam()
     * @uses MedewerkerTemp::setEmailadresPrive()
     * @uses MedewerkerTemp::setEmailadresWerk()
     * @uses MedewerkerTemp::setGeboorteDatum()
     * @uses MedewerkerTemp::setGeboortenaam()
     * @uses MedewerkerTemp::setGeboortePlaats()
     * @uses MedewerkerTemp::setGeslacht()
     * @uses MedewerkerTemp::setOpmerkingenInteresses()
     * @uses MedewerkerTemp::setOpmerkingenMotivatie()
     * @uses MedewerkerTemp::setOpmerkingenOpleiding()
     * @uses MedewerkerTemp::setOpmerkingenWerkervaring()
     * @uses MedewerkerTemp::setPlaats()
     * @uses MedewerkerTemp::setStraatInclNummer()
     * @uses MedewerkerTemp::setPostcode()
     * @uses MedewerkerTemp::setRoepnaam()
     * @uses MedewerkerTemp::setTelefoonVast()
     * @uses MedewerkerTemp::setTelefoonMobiel()
     * @uses MedewerkerTemp::setTelefoonWerk()
     * @uses MedewerkerTemp::setVoorletters()
     * @uses MedewerkerTemp::setVoornaam()
     * @uses MedewerkerTemp::setVoorvoegsels()
     * @uses MedewerkerTemp::set_InterneSollicitatie()
     * @uses MedewerkerTemp::set_Mobiliteitskandidaat()
     * @uses MedewerkerTemp::setVacatureNummer()
     * @uses MedewerkerTemp::setCode_Wervingskanaal()
     * @uses MedewerkerTemp::setCode_Opleidingsniveau()
     * @uses MedewerkerTemp::setCode_Werkervaring()
     * @uses MedewerkerTemp::setSD_Criteria_NP_MedewerkerTemp()
     * @uses MedewerkerTemp::setBase64Decode_CV()
     * @uses MedewerkerTemp::setBase64Decode_Motivatiebrief()
     * @uses MedewerkerTemp::setBase64Decode_ExtraBijlage()
     * @uses MedewerkerTemp::setBestandsnaam_CV()
     * @uses MedewerkerTemp::setBestandsnaam_Motivatiebrief()
     * @uses MedewerkerTemp::setBestandsnaam_ExtraBijlage()
     * @uses MedewerkerTemp::set_OpenSollicitatie()
     * @uses MedewerkerTemp::setLinkedIn()
     * @uses MedewerkerTemp::setTwitter()
     * @uses MedewerkerTemp::set_StopzettenJobalert()
     * @uses MedewerkerTemp::setSD_Kenmerk2_NP_MedewerkerTemp()
     * @uses MedewerkerTemp::setSD_Kenmerk1_NP_MedewerkerTemp()
     * @param string $achternaam
     * @param string $emailadresPrive
     * @param string $emailadresWerk
     * @param string $geboorteDatum
     * @param string $geboortenaam
     * @param string $geboortePlaats
     * @param string $geslacht
     * @param string $opmerkingenInteresses
     * @param string $opmerkingenMotivatie
     * @param string $opmerkingenOpleiding
     * @param string $opmerkingenWerkervaring
     * @param string $plaats
     * @param string $straatInclNummer
     * @param string $postcode
     * @param string $roepnaam
     * @param string $telefoonVast
     * @param string $telefoonMobiel
     * @param string $telefoonWerk
     * @param string $voorletters
     * @param string $voornaam
     * @param string $voorvoegsels
     * @param bool $_InterneSollicitatie
     * @param bool $_Mobiliteitskandidaat
     * @param string $vacatureNummer
     * @param int $code_Wervingskanaal
     * @param int $code_Opleidingsniveau
     * @param int $code_Werkervaring
     * @param \StructType\SD_Criteria_NP_MedewerkerTemp $sD_Criteria_NP_MedewerkerTemp
     * @param string $base64Decode_CV
     * @param string $base64Decode_Motivatiebrief
     * @param string $base64Decode_ExtraBijlage
     * @param string $bestandsnaam_CV
     * @param string $bestandsnaam_Motivatiebrief
     * @param string $bestandsnaam_ExtraBijlage
     * @param bool $_OpenSollicitatie
     * @param string $linkedIn
     * @param string $twitter
     * @param bool $_StopzettenJobalert
     * @param \StructType\SD_Kenmerk2_NP_MedewerkerTemp $sD_Kenmerk2_NP_MedewerkerTemp
     * @param \StructType\SD_Kenmerk1_NP_MedewerkerTemp $sD_Kenmerk1_NP_MedewerkerTemp
     */
    public function __construct($achternaam = null, $emailadresPrive = null, $emailadresWerk = null, $geboorteDatum = null, $geboortenaam = null, $geboortePlaats = null, $geslacht = null, $opmerkingenInteresses = null, $opmerkingenMotivatie = null, $opmerkingenOpleiding = null, $opmerkingenWerkervaring = null, $plaats = null, $straatInclNummer = null, $postcode = null, $roepnaam = null, $telefoonVast = null, $telefoonMobiel = null, $telefoonWerk = null, $voorletters = null, $voornaam = null, $voorvoegsels = null, $_InterneSollicitatie = null, $_Mobiliteitskandidaat = null, $vacatureNummer = null, $code_Wervingskanaal = null, $code_Opleidingsniveau = null, $code_Werkervaring = null, \StructType\SD_Criteria_NP_MedewerkerTemp $sD_Criteria_NP_MedewerkerTemp = null, $base64Decode_CV = null, $base64Decode_Motivatiebrief = null, $base64Decode_ExtraBijlage = null, $bestandsnaam_CV = null, $bestandsnaam_Motivatiebrief = null, $bestandsnaam_ExtraBijlage = null, $_OpenSollicitatie = null, $linkedIn = null, $twitter = null, $_StopzettenJobalert = null, \StructType\SD_Kenmerk2_NP_MedewerkerTemp $sD_Kenmerk2_NP_MedewerkerTemp = null, \StructType\SD_Kenmerk1_NP_MedewerkerTemp $sD_Kenmerk1_NP_MedewerkerTemp = null)
    {
        $this
            ->setAchternaam($achternaam)
            ->setEmailadresPrive($emailadresPrive)
            ->setEmailadresWerk($emailadresWerk)
            ->setGeboorteDatum($geboorteDatum)
            ->setGeboortenaam($geboortenaam)
            ->setGeboortePlaats($geboortePlaats)
            ->setGeslacht($geslacht)
            ->setOpmerkingenInteresses($opmerkingenInteresses)
            ->setOpmerkingenMotivatie($opmerkingenMotivatie)
            ->setOpmerkingenOpleiding($opmerkingenOpleiding)
            ->setOpmerkingenWerkervaring($opmerkingenWerkervaring)
            ->setPlaats($plaats)
            ->setStraatInclNummer($straatInclNummer)
            ->setPostcode($postcode)
            ->setRoepnaam($roepnaam)
            ->setTelefoonVast($telefoonVast)
            ->setTelefoonMobiel($telefoonMobiel)
            ->setTelefoonWerk($telefoonWerk)
            ->setVoorletters($voorletters)
            ->setVoornaam($voornaam)
            ->setVoorvoegsels($voorvoegsels)
            ->set_InterneSollicitatie($_InterneSollicitatie)
            ->set_Mobiliteitskandidaat($_Mobiliteitskandidaat)
            ->setVacatureNummer($vacatureNummer)
            ->setCode_Wervingskanaal($code_Wervingskanaal)
            ->setCode_Opleidingsniveau($code_Opleidingsniveau)
            ->setCode_Werkervaring($code_Werkervaring)
            ->setSD_Criteria_NP_MedewerkerTemp($sD_Criteria_NP_MedewerkerTemp)
            ->setBase64Decode_CV($base64Decode_CV)
            ->setBase64Decode_Motivatiebrief($base64Decode_Motivatiebrief)
            ->setBase64Decode_ExtraBijlage($base64Decode_ExtraBijlage)
            ->setBestandsnaam_CV($bestandsnaam_CV)
            ->setBestandsnaam_Motivatiebrief($bestandsnaam_Motivatiebrief)
            ->setBestandsnaam_ExtraBijlage($bestandsnaam_ExtraBijlage)
            ->set_OpenSollicitatie($_OpenSollicitatie)
            ->setLinkedIn($linkedIn)
            ->setTwitter($twitter)
            ->set_StopzettenJobalert($_StopzettenJobalert)
            ->setSD_Kenmerk2_NP_MedewerkerTemp($sD_Kenmerk2_NP_MedewerkerTemp)
            ->setSD_Kenmerk1_NP_MedewerkerTemp($sD_Kenmerk1_NP_MedewerkerTemp);
    }
    /**
     * Get Achternaam value
     * @return string|null
     */
    public function getAchternaam()
    {
        return $this->Achternaam;
    }
    /**
     * Set Achternaam value
     * @param string $achternaam
     * @return \StructType\MedewerkerTemp
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($achternaam) && strlen($achternaam) > 133) || (is_array($achternaam) && count($achternaam) > 133)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 133 element(s) or a scalar of 133 character(s) at most, "%d" length given', is_scalar($achternaam) ? strlen($achternaam) : count($achternaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achternaam)), __LINE__);
        }
        $this->Achternaam = $achternaam;
        return $this;
    }
    /**
     * Get EmailadresPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailadresPrive()
    {
        return isset($this->EmailadresPrive) ? $this->EmailadresPrive : null;
    }
    /**
     * Set EmailadresPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailadresPrive
     * @return \StructType\MedewerkerTemp
     */
    public function setEmailadresPrive($emailadresPrive = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailadresPrive) && strlen($emailadresPrive) > 200) || (is_array($emailadresPrive) && count($emailadresPrive) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailadresPrive) ? strlen($emailadresPrive) : count($emailadresPrive)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailadresPrive) && !is_string($emailadresPrive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailadresPrive)), __LINE__);
        }
        if (is_null($emailadresPrive) || (is_array($emailadresPrive) && empty($emailadresPrive))) {
            unset($this->EmailadresPrive);
        } else {
            $this->EmailadresPrive = $emailadresPrive;
        }
        return $this;
    }
    /**
     * Get EmailadresWerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailadresWerk()
    {
        return isset($this->EmailadresWerk) ? $this->EmailadresWerk : null;
    }
    /**
     * Set EmailadresWerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailadresWerk
     * @return \StructType\MedewerkerTemp
     */
    public function setEmailadresWerk($emailadresWerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailadresWerk) && strlen($emailadresWerk) > 200) || (is_array($emailadresWerk) && count($emailadresWerk) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailadresWerk) ? strlen($emailadresWerk) : count($emailadresWerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailadresWerk) && !is_string($emailadresWerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailadresWerk)), __LINE__);
        }
        if (is_null($emailadresWerk) || (is_array($emailadresWerk) && empty($emailadresWerk))) {
            unset($this->EmailadresWerk);
        } else {
            $this->EmailadresWerk = $emailadresWerk;
        }
        return $this;
    }
    /**
     * Get GeboorteDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboorteDatum()
    {
        return isset($this->GeboorteDatum) ? $this->GeboorteDatum : null;
    }
    /**
     * Set GeboorteDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboorteDatum
     * @return \StructType\MedewerkerTemp
     */
    public function setGeboorteDatum($geboorteDatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboorteDatum) && !is_string($geboorteDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboorteDatum)), __LINE__);
        }
        if (is_null($geboorteDatum) || (is_array($geboorteDatum) && empty($geboorteDatum))) {
            unset($this->GeboorteDatum);
        } else {
            $this->GeboorteDatum = $geboorteDatum;
        }
        return $this;
    }
    /**
     * Get Geboortenaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortenaam()
    {
        return isset($this->Geboortenaam) ? $this->Geboortenaam : null;
    }
    /**
     * Set Geboortenaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortenaam
     * @return \StructType\MedewerkerTemp
     */
    public function setGeboortenaam($geboortenaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($geboortenaam) && strlen($geboortenaam) > 50) || (is_array($geboortenaam) && count($geboortenaam) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($geboortenaam) ? strlen($geboortenaam) : count($geboortenaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($geboortenaam) && !is_string($geboortenaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboortenaam)), __LINE__);
        }
        if (is_null($geboortenaam) || (is_array($geboortenaam) && empty($geboortenaam))) {
            unset($this->Geboortenaam);
        } else {
            $this->Geboortenaam = $geboortenaam;
        }
        return $this;
    }
    /**
     * Get GeboortePlaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortePlaats()
    {
        return isset($this->GeboortePlaats) ? $this->GeboortePlaats : null;
    }
    /**
     * Set GeboortePlaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortePlaats
     * @return \StructType\MedewerkerTemp
     */
    public function setGeboortePlaats($geboortePlaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($geboortePlaats) && strlen($geboortePlaats) > 200) || (is_array($geboortePlaats) && count($geboortePlaats) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($geboortePlaats) ? strlen($geboortePlaats) : count($geboortePlaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($geboortePlaats) && !is_string($geboortePlaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboortePlaats)), __LINE__);
        }
        if (is_null($geboortePlaats) || (is_array($geboortePlaats) && empty($geboortePlaats))) {
            unset($this->GeboortePlaats);
        } else {
            $this->GeboortePlaats = $geboortePlaats;
        }
        return $this;
    }
    /**
     * Get Geslacht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeslacht()
    {
        return isset($this->Geslacht) ? $this->Geslacht : null;
    }
    /**
     * Set Geslacht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Geslacht::valueIsValid()
     * @uses \EnumType\Geslacht::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geslacht
     * @return \StructType\MedewerkerTemp
     */
    public function setGeslacht($geslacht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Geslacht::valueIsValid($geslacht)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geslacht, implode(', ', \EnumType\Geslacht::getValidValues())), __LINE__);
        }
        if (is_null($geslacht) || (is_array($geslacht) && empty($geslacht))) {
            unset($this->Geslacht);
        } else {
            $this->Geslacht = $geslacht;
        }
        return $this;
    }
    /**
     * Get OpmerkingenInteresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpmerkingenInteresses()
    {
        return isset($this->OpmerkingenInteresses) ? $this->OpmerkingenInteresses : null;
    }
    /**
     * Set OpmerkingenInteresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opmerkingenInteresses
     * @return \StructType\MedewerkerTemp
     */
    public function setOpmerkingenInteresses($opmerkingenInteresses = null)
    {
        // validation for constraint: string
        if (!is_null($opmerkingenInteresses) && !is_string($opmerkingenInteresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opmerkingenInteresses)), __LINE__);
        }
        if (is_null($opmerkingenInteresses) || (is_array($opmerkingenInteresses) && empty($opmerkingenInteresses))) {
            unset($this->OpmerkingenInteresses);
        } else {
            $this->OpmerkingenInteresses = $opmerkingenInteresses;
        }
        return $this;
    }
    /**
     * Get OpmerkingenMotivatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpmerkingenMotivatie()
    {
        return isset($this->OpmerkingenMotivatie) ? $this->OpmerkingenMotivatie : null;
    }
    /**
     * Set OpmerkingenMotivatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opmerkingenMotivatie
     * @return \StructType\MedewerkerTemp
     */
    public function setOpmerkingenMotivatie($opmerkingenMotivatie = null)
    {
        // validation for constraint: string
        if (!is_null($opmerkingenMotivatie) && !is_string($opmerkingenMotivatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opmerkingenMotivatie)), __LINE__);
        }
        if (is_null($opmerkingenMotivatie) || (is_array($opmerkingenMotivatie) && empty($opmerkingenMotivatie))) {
            unset($this->OpmerkingenMotivatie);
        } else {
            $this->OpmerkingenMotivatie = $opmerkingenMotivatie;
        }
        return $this;
    }
    /**
     * Get OpmerkingenOpleiding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpmerkingenOpleiding()
    {
        return isset($this->OpmerkingenOpleiding) ? $this->OpmerkingenOpleiding : null;
    }
    /**
     * Set OpmerkingenOpleiding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opmerkingenOpleiding
     * @return \StructType\MedewerkerTemp
     */
    public function setOpmerkingenOpleiding($opmerkingenOpleiding = null)
    {
        // validation for constraint: string
        if (!is_null($opmerkingenOpleiding) && !is_string($opmerkingenOpleiding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opmerkingenOpleiding)), __LINE__);
        }
        if (is_null($opmerkingenOpleiding) || (is_array($opmerkingenOpleiding) && empty($opmerkingenOpleiding))) {
            unset($this->OpmerkingenOpleiding);
        } else {
            $this->OpmerkingenOpleiding = $opmerkingenOpleiding;
        }
        return $this;
    }
    /**
     * Get OpmerkingenWerkervaring value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpmerkingenWerkervaring()
    {
        return isset($this->OpmerkingenWerkervaring) ? $this->OpmerkingenWerkervaring : null;
    }
    /**
     * Set OpmerkingenWerkervaring value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opmerkingenWerkervaring
     * @return \StructType\MedewerkerTemp
     */
    public function setOpmerkingenWerkervaring($opmerkingenWerkervaring = null)
    {
        // validation for constraint: string
        if (!is_null($opmerkingenWerkervaring) && !is_string($opmerkingenWerkervaring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opmerkingenWerkervaring)), __LINE__);
        }
        if (is_null($opmerkingenWerkervaring) || (is_array($opmerkingenWerkervaring) && empty($opmerkingenWerkervaring))) {
            unset($this->OpmerkingenWerkervaring);
        } else {
            $this->OpmerkingenWerkervaring = $opmerkingenWerkervaring;
        }
        return $this;
    }
    /**
     * Get Plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->Plaats) ? $this->Plaats : null;
    }
    /**
     * Set Plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \StructType\MedewerkerTemp
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($plaats) && strlen($plaats) > 200) || (is_array($plaats) && count($plaats) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($plaats) ? strlen($plaats) : count($plaats)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->Plaats);
        } else {
            $this->Plaats = $plaats;
        }
        return $this;
    }
    /**
     * Get StraatInclNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraatInclNummer()
    {
        return isset($this->StraatInclNummer) ? $this->StraatInclNummer : null;
    }
    /**
     * Set StraatInclNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straatInclNummer
     * @return \StructType\MedewerkerTemp
     */
    public function setStraatInclNummer($straatInclNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($straatInclNummer) && strlen($straatInclNummer) > 200) || (is_array($straatInclNummer) && count($straatInclNummer) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($straatInclNummer) ? strlen($straatInclNummer) : count($straatInclNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($straatInclNummer) && !is_string($straatInclNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straatInclNummer)), __LINE__);
        }
        if (is_null($straatInclNummer) || (is_array($straatInclNummer) && empty($straatInclNummer))) {
            unset($this->StraatInclNummer);
        } else {
            $this->StraatInclNummer = $straatInclNummer;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\MedewerkerTemp
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postcode) && strlen($postcode) > 200) || (is_array($postcode) && count($postcode) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($postcode) ? strlen($postcode) : count($postcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get Roepnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoepnaam()
    {
        return isset($this->Roepnaam) ? $this->Roepnaam : null;
    }
    /**
     * Set Roepnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roepnaam
     * @return \StructType\MedewerkerTemp
     */
    public function setRoepnaam($roepnaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($roepnaam) && strlen($roepnaam) > 200) || (is_array($roepnaam) && count($roepnaam) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($roepnaam) ? strlen($roepnaam) : count($roepnaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roepnaam) && !is_string($roepnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roepnaam)), __LINE__);
        }
        if (is_null($roepnaam) || (is_array($roepnaam) && empty($roepnaam))) {
            unset($this->Roepnaam);
        } else {
            $this->Roepnaam = $roepnaam;
        }
        return $this;
    }
    /**
     * Get TelefoonVast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonVast()
    {
        return isset($this->TelefoonVast) ? $this->TelefoonVast : null;
    }
    /**
     * Set TelefoonVast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonVast
     * @return \StructType\MedewerkerTemp
     */
    public function setTelefoonVast($telefoonVast = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telefoonVast) && strlen($telefoonVast) > 200) || (is_array($telefoonVast) && count($telefoonVast) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($telefoonVast) ? strlen($telefoonVast) : count($telefoonVast)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telefoonVast) && !is_string($telefoonVast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonVast)), __LINE__);
        }
        if (is_null($telefoonVast) || (is_array($telefoonVast) && empty($telefoonVast))) {
            unset($this->TelefoonVast);
        } else {
            $this->TelefoonVast = $telefoonVast;
        }
        return $this;
    }
    /**
     * Get TelefoonMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonMobiel()
    {
        return isset($this->TelefoonMobiel) ? $this->TelefoonMobiel : null;
    }
    /**
     * Set TelefoonMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonMobiel
     * @return \StructType\MedewerkerTemp
     */
    public function setTelefoonMobiel($telefoonMobiel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telefoonMobiel) && strlen($telefoonMobiel) > 200) || (is_array($telefoonMobiel) && count($telefoonMobiel) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($telefoonMobiel) ? strlen($telefoonMobiel) : count($telefoonMobiel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telefoonMobiel) && !is_string($telefoonMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonMobiel)), __LINE__);
        }
        if (is_null($telefoonMobiel) || (is_array($telefoonMobiel) && empty($telefoonMobiel))) {
            unset($this->TelefoonMobiel);
        } else {
            $this->TelefoonMobiel = $telefoonMobiel;
        }
        return $this;
    }
    /**
     * Get TelefoonWerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonWerk()
    {
        return isset($this->TelefoonWerk) ? $this->TelefoonWerk : null;
    }
    /**
     * Set TelefoonWerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonWerk
     * @return \StructType\MedewerkerTemp
     */
    public function setTelefoonWerk($telefoonWerk = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telefoonWerk) && strlen($telefoonWerk) > 200) || (is_array($telefoonWerk) && count($telefoonWerk) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($telefoonWerk) ? strlen($telefoonWerk) : count($telefoonWerk)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telefoonWerk) && !is_string($telefoonWerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonWerk)), __LINE__);
        }
        if (is_null($telefoonWerk) || (is_array($telefoonWerk) && empty($telefoonWerk))) {
            unset($this->TelefoonWerk);
        } else {
            $this->TelefoonWerk = $telefoonWerk;
        }
        return $this;
    }
    /**
     * Get Voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->Voorletters) ? $this->Voorletters : null;
    }
    /**
     * Set Voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \StructType\MedewerkerTemp
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voorletters) && strlen($voorletters) > 20) || (is_array($voorletters) && count($voorletters) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($voorletters) ? strlen($voorletters) : count($voorletters)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->Voorletters);
        } else {
            $this->Voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get Voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->Voornaam) ? $this->Voornaam : null;
    }
    /**
     * Set Voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \StructType\MedewerkerTemp
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voornaam) && strlen($voornaam) > 200) || (is_array($voornaam) && count($voornaam) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($voornaam) ? strlen($voornaam) : count($voornaam)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->Voornaam);
        } else {
            $this->Voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get Voorvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorvoegsels()
    {
        return isset($this->Voorvoegsels) ? $this->Voorvoegsels : null;
    }
    /**
     * Set Voorvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorvoegsels
     * @return \StructType\MedewerkerTemp
     */
    public function setVoorvoegsels($voorvoegsels = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($voorvoegsels) && strlen($voorvoegsels) > 15) || (is_array($voorvoegsels) && count($voorvoegsels) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($voorvoegsels) ? strlen($voorvoegsels) : count($voorvoegsels)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voorvoegsels) && !is_string($voorvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorvoegsels)), __LINE__);
        }
        if (is_null($voorvoegsels) || (is_array($voorvoegsels) && empty($voorvoegsels))) {
            unset($this->Voorvoegsels);
        } else {
            $this->Voorvoegsels = $voorvoegsels;
        }
        return $this;
    }
    /**
     * Get _InterneSollicitatie value
     * @return bool|null
     */
    public function get_InterneSollicitatie()
    {
        return $this->_InterneSollicitatie;
    }
    /**
     * Set _InterneSollicitatie value
     * @param bool $_InterneSollicitatie
     * @return \StructType\MedewerkerTemp
     */
    public function set_InterneSollicitatie($_InterneSollicitatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($_InterneSollicitatie) && !is_bool($_InterneSollicitatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_InterneSollicitatie)), __LINE__);
        }
        $this->_InterneSollicitatie = $_InterneSollicitatie;
        return $this;
    }
    /**
     * Get _Mobiliteitskandidaat value
     * @return bool|null
     */
    public function get_Mobiliteitskandidaat()
    {
        return $this->_Mobiliteitskandidaat;
    }
    /**
     * Set _Mobiliteitskandidaat value
     * @param bool $_Mobiliteitskandidaat
     * @return \StructType\MedewerkerTemp
     */
    public function set_Mobiliteitskandidaat($_Mobiliteitskandidaat = null)
    {
        // validation for constraint: boolean
        if (!is_null($_Mobiliteitskandidaat) && !is_bool($_Mobiliteitskandidaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_Mobiliteitskandidaat)), __LINE__);
        }
        $this->_Mobiliteitskandidaat = $_Mobiliteitskandidaat;
        return $this;
    }
    /**
     * Get VacatureNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVacatureNummer()
    {
        return isset($this->VacatureNummer) ? $this->VacatureNummer : null;
    }
    /**
     * Set VacatureNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vacatureNummer
     * @return \StructType\MedewerkerTemp
     */
    public function setVacatureNummer($vacatureNummer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vacatureNummer) && strlen($vacatureNummer) > 200) || (is_array($vacatureNummer) && count($vacatureNummer) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($vacatureNummer) ? strlen($vacatureNummer) : count($vacatureNummer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vacatureNummer) && !is_string($vacatureNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vacatureNummer)), __LINE__);
        }
        if (is_null($vacatureNummer) || (is_array($vacatureNummer) && empty($vacatureNummer))) {
            unset($this->VacatureNummer);
        } else {
            $this->VacatureNummer = $vacatureNummer;
        }
        return $this;
    }
    /**
     * Get Code_Wervingskanaal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode_Wervingskanaal()
    {
        return isset($this->Code_Wervingskanaal) ? $this->Code_Wervingskanaal : null;
    }
    /**
     * Set Code_Wervingskanaal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code_Wervingskanaal
     * @return \StructType\MedewerkerTemp
     */
    public function setCode_Wervingskanaal($code_Wervingskanaal = null)
    {
        // validation for constraint: int
        if (!is_null($code_Wervingskanaal) && !is_numeric($code_Wervingskanaal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code_Wervingskanaal)), __LINE__);
        }
        if (is_null($code_Wervingskanaal) || (is_array($code_Wervingskanaal) && empty($code_Wervingskanaal))) {
            unset($this->Code_Wervingskanaal);
        } else {
            $this->Code_Wervingskanaal = $code_Wervingskanaal;
        }
        return $this;
    }
    /**
     * Get Code_Opleidingsniveau value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode_Opleidingsniveau()
    {
        return isset($this->Code_Opleidingsniveau) ? $this->Code_Opleidingsniveau : null;
    }
    /**
     * Set Code_Opleidingsniveau value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code_Opleidingsniveau
     * @return \StructType\MedewerkerTemp
     */
    public function setCode_Opleidingsniveau($code_Opleidingsniveau = null)
    {
        // validation for constraint: int
        if (!is_null($code_Opleidingsniveau) && !is_numeric($code_Opleidingsniveau)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code_Opleidingsniveau)), __LINE__);
        }
        if (is_null($code_Opleidingsniveau) || (is_array($code_Opleidingsniveau) && empty($code_Opleidingsniveau))) {
            unset($this->Code_Opleidingsniveau);
        } else {
            $this->Code_Opleidingsniveau = $code_Opleidingsniveau;
        }
        return $this;
    }
    /**
     * Get Code_Werkervaring value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCode_Werkervaring()
    {
        return isset($this->Code_Werkervaring) ? $this->Code_Werkervaring : null;
    }
    /**
     * Set Code_Werkervaring value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $code_Werkervaring
     * @return \StructType\MedewerkerTemp
     */
    public function setCode_Werkervaring($code_Werkervaring = null)
    {
        // validation for constraint: int
        if (!is_null($code_Werkervaring) && !is_numeric($code_Werkervaring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code_Werkervaring)), __LINE__);
        }
        if (is_null($code_Werkervaring) || (is_array($code_Werkervaring) && empty($code_Werkervaring))) {
            unset($this->Code_Werkervaring);
        } else {
            $this->Code_Werkervaring = $code_Werkervaring;
        }
        return $this;
    }
    /**
     * Get SD_Criteria_NP_MedewerkerTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SD_Criteria_NP_MedewerkerTemp|null
     */
    public function getSD_Criteria_NP_MedewerkerTemp()
    {
        return isset($this->SD_Criteria_NP_MedewerkerTemp) ? $this->SD_Criteria_NP_MedewerkerTemp : null;
    }
    /**
     * Set SD_Criteria_NP_MedewerkerTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SD_Criteria_NP_MedewerkerTemp $sD_Criteria_NP_MedewerkerTemp
     * @return \StructType\MedewerkerTemp
     */
    public function setSD_Criteria_NP_MedewerkerTemp(\StructType\SD_Criteria_NP_MedewerkerTemp $sD_Criteria_NP_MedewerkerTemp = null)
    {
        if (is_null($sD_Criteria_NP_MedewerkerTemp) || (is_array($sD_Criteria_NP_MedewerkerTemp) && empty($sD_Criteria_NP_MedewerkerTemp))) {
            unset($this->SD_Criteria_NP_MedewerkerTemp);
        } else {
            $this->SD_Criteria_NP_MedewerkerTemp = $sD_Criteria_NP_MedewerkerTemp;
        }
        return $this;
    }
    /**
     * Get Base64Decode_CV value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBase64Decode_CV()
    {
        return isset($this->Base64Decode_CV) ? $this->Base64Decode_CV : null;
    }
    /**
     * Set Base64Decode_CV value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $base64Decode_CV
     * @return \StructType\MedewerkerTemp
     */
    public function setBase64Decode_CV($base64Decode_CV = null)
    {
        // validation for constraint: string
        if (!is_null($base64Decode_CV) && !is_string($base64Decode_CV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base64Decode_CV)), __LINE__);
        }
        if (is_null($base64Decode_CV) || (is_array($base64Decode_CV) && empty($base64Decode_CV))) {
            unset($this->Base64Decode_CV);
        } else {
            $this->Base64Decode_CV = $base64Decode_CV;
        }
        return $this;
    }
    /**
     * Get Base64Decode_Motivatiebrief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBase64Decode_Motivatiebrief()
    {
        return isset($this->Base64Decode_Motivatiebrief) ? $this->Base64Decode_Motivatiebrief : null;
    }
    /**
     * Set Base64Decode_Motivatiebrief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $base64Decode_Motivatiebrief
     * @return \StructType\MedewerkerTemp
     */
    public function setBase64Decode_Motivatiebrief($base64Decode_Motivatiebrief = null)
    {
        // validation for constraint: string
        if (!is_null($base64Decode_Motivatiebrief) && !is_string($base64Decode_Motivatiebrief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base64Decode_Motivatiebrief)), __LINE__);
        }
        if (is_null($base64Decode_Motivatiebrief) || (is_array($base64Decode_Motivatiebrief) && empty($base64Decode_Motivatiebrief))) {
            unset($this->Base64Decode_Motivatiebrief);
        } else {
            $this->Base64Decode_Motivatiebrief = $base64Decode_Motivatiebrief;
        }
        return $this;
    }
    /**
     * Get Base64Decode_ExtraBijlage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBase64Decode_ExtraBijlage()
    {
        return isset($this->Base64Decode_ExtraBijlage) ? $this->Base64Decode_ExtraBijlage : null;
    }
    /**
     * Set Base64Decode_ExtraBijlage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $base64Decode_ExtraBijlage
     * @return \StructType\MedewerkerTemp
     */
    public function setBase64Decode_ExtraBijlage($base64Decode_ExtraBijlage = null)
    {
        // validation for constraint: string
        if (!is_null($base64Decode_ExtraBijlage) && !is_string($base64Decode_ExtraBijlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base64Decode_ExtraBijlage)), __LINE__);
        }
        if (is_null($base64Decode_ExtraBijlage) || (is_array($base64Decode_ExtraBijlage) && empty($base64Decode_ExtraBijlage))) {
            unset($this->Base64Decode_ExtraBijlage);
        } else {
            $this->Base64Decode_ExtraBijlage = $base64Decode_ExtraBijlage;
        }
        return $this;
    }
    /**
     * Get Bestandsnaam_CV value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBestandsnaam_CV()
    {
        return isset($this->Bestandsnaam_CV) ? $this->Bestandsnaam_CV : null;
    }
    /**
     * Set Bestandsnaam_CV value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bestandsnaam_CV
     * @return \StructType\MedewerkerTemp
     */
    public function setBestandsnaam_CV($bestandsnaam_CV = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bestandsnaam_CV) && strlen($bestandsnaam_CV) > 500) || (is_array($bestandsnaam_CV) && count($bestandsnaam_CV) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($bestandsnaam_CV) ? strlen($bestandsnaam_CV) : count($bestandsnaam_CV)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bestandsnaam_CV) && !is_string($bestandsnaam_CV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestandsnaam_CV)), __LINE__);
        }
        if (is_null($bestandsnaam_CV) || (is_array($bestandsnaam_CV) && empty($bestandsnaam_CV))) {
            unset($this->Bestandsnaam_CV);
        } else {
            $this->Bestandsnaam_CV = $bestandsnaam_CV;
        }
        return $this;
    }
    /**
     * Get Bestandsnaam_Motivatiebrief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBestandsnaam_Motivatiebrief()
    {
        return isset($this->Bestandsnaam_Motivatiebrief) ? $this->Bestandsnaam_Motivatiebrief : null;
    }
    /**
     * Set Bestandsnaam_Motivatiebrief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bestandsnaam_Motivatiebrief
     * @return \StructType\MedewerkerTemp
     */
    public function setBestandsnaam_Motivatiebrief($bestandsnaam_Motivatiebrief = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bestandsnaam_Motivatiebrief) && strlen($bestandsnaam_Motivatiebrief) > 500) || (is_array($bestandsnaam_Motivatiebrief) && count($bestandsnaam_Motivatiebrief) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($bestandsnaam_Motivatiebrief) ? strlen($bestandsnaam_Motivatiebrief) : count($bestandsnaam_Motivatiebrief)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bestandsnaam_Motivatiebrief) && !is_string($bestandsnaam_Motivatiebrief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestandsnaam_Motivatiebrief)), __LINE__);
        }
        if (is_null($bestandsnaam_Motivatiebrief) || (is_array($bestandsnaam_Motivatiebrief) && empty($bestandsnaam_Motivatiebrief))) {
            unset($this->Bestandsnaam_Motivatiebrief);
        } else {
            $this->Bestandsnaam_Motivatiebrief = $bestandsnaam_Motivatiebrief;
        }
        return $this;
    }
    /**
     * Get Bestandsnaam_ExtraBijlage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBestandsnaam_ExtraBijlage()
    {
        return isset($this->Bestandsnaam_ExtraBijlage) ? $this->Bestandsnaam_ExtraBijlage : null;
    }
    /**
     * Set Bestandsnaam_ExtraBijlage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bestandsnaam_ExtraBijlage
     * @return \StructType\MedewerkerTemp
     */
    public function setBestandsnaam_ExtraBijlage($bestandsnaam_ExtraBijlage = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bestandsnaam_ExtraBijlage) && strlen($bestandsnaam_ExtraBijlage) > 500) || (is_array($bestandsnaam_ExtraBijlage) && count($bestandsnaam_ExtraBijlage) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($bestandsnaam_ExtraBijlage) ? strlen($bestandsnaam_ExtraBijlage) : count($bestandsnaam_ExtraBijlage)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bestandsnaam_ExtraBijlage) && !is_string($bestandsnaam_ExtraBijlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bestandsnaam_ExtraBijlage)), __LINE__);
        }
        if (is_null($bestandsnaam_ExtraBijlage) || (is_array($bestandsnaam_ExtraBijlage) && empty($bestandsnaam_ExtraBijlage))) {
            unset($this->Bestandsnaam_ExtraBijlage);
        } else {
            $this->Bestandsnaam_ExtraBijlage = $bestandsnaam_ExtraBijlage;
        }
        return $this;
    }
    /**
     * Get _OpenSollicitatie value
     * @return bool|null
     */
    public function get_OpenSollicitatie()
    {
        return $this->_OpenSollicitatie;
    }
    /**
     * Set _OpenSollicitatie value
     * @param bool $_OpenSollicitatie
     * @return \StructType\MedewerkerTemp
     */
    public function set_OpenSollicitatie($_OpenSollicitatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($_OpenSollicitatie) && !is_bool($_OpenSollicitatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_OpenSollicitatie)), __LINE__);
        }
        $this->_OpenSollicitatie = $_OpenSollicitatie;
        return $this;
    }
    /**
     * Get LinkedIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkedIn()
    {
        return isset($this->LinkedIn) ? $this->LinkedIn : null;
    }
    /**
     * Set LinkedIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkedIn
     * @return \StructType\MedewerkerTemp
     */
    public function setLinkedIn($linkedIn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($linkedIn) && strlen($linkedIn) > 50) || (is_array($linkedIn) && count($linkedIn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($linkedIn) ? strlen($linkedIn) : count($linkedIn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($linkedIn) && !is_string($linkedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkedIn)), __LINE__);
        }
        if (is_null($linkedIn) || (is_array($linkedIn) && empty($linkedIn))) {
            unset($this->LinkedIn);
        } else {
            $this->LinkedIn = $linkedIn;
        }
        return $this;
    }
    /**
     * Get Twitter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTwitter()
    {
        return isset($this->Twitter) ? $this->Twitter : null;
    }
    /**
     * Set Twitter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $twitter
     * @return \StructType\MedewerkerTemp
     */
    public function setTwitter($twitter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($twitter) && strlen($twitter) > 50) || (is_array($twitter) && count($twitter) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($twitter) ? strlen($twitter) : count($twitter)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($twitter) && !is_string($twitter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twitter)), __LINE__);
        }
        if (is_null($twitter) || (is_array($twitter) && empty($twitter))) {
            unset($this->Twitter);
        } else {
            $this->Twitter = $twitter;
        }
        return $this;
    }
    /**
     * Get _StopzettenJobalert value
     * @return bool|null
     */
    public function get_StopzettenJobalert()
    {
        return $this->_StopzettenJobalert;
    }
    /**
     * Set _StopzettenJobalert value
     * @param bool $_StopzettenJobalert
     * @return \StructType\MedewerkerTemp
     */
    public function set_StopzettenJobalert($_StopzettenJobalert = null)
    {
        // validation for constraint: boolean
        if (!is_null($_StopzettenJobalert) && !is_bool($_StopzettenJobalert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_StopzettenJobalert)), __LINE__);
        }
        $this->_StopzettenJobalert = $_StopzettenJobalert;
        return $this;
    }
    /**
     * Get SD_Kenmerk2_NP_MedewerkerTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SD_Kenmerk2_NP_MedewerkerTemp|null
     */
    public function getSD_Kenmerk2_NP_MedewerkerTemp()
    {
        return isset($this->SD_Kenmerk2_NP_MedewerkerTemp) ? $this->SD_Kenmerk2_NP_MedewerkerTemp : null;
    }
    /**
     * Set SD_Kenmerk2_NP_MedewerkerTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SD_Kenmerk2_NP_MedewerkerTemp $sD_Kenmerk2_NP_MedewerkerTemp
     * @return \StructType\MedewerkerTemp
     */
    public function setSD_Kenmerk2_NP_MedewerkerTemp(\StructType\SD_Kenmerk2_NP_MedewerkerTemp $sD_Kenmerk2_NP_MedewerkerTemp = null)
    {
        if (is_null($sD_Kenmerk2_NP_MedewerkerTemp) || (is_array($sD_Kenmerk2_NP_MedewerkerTemp) && empty($sD_Kenmerk2_NP_MedewerkerTemp))) {
            unset($this->SD_Kenmerk2_NP_MedewerkerTemp);
        } else {
            $this->SD_Kenmerk2_NP_MedewerkerTemp = $sD_Kenmerk2_NP_MedewerkerTemp;
        }
        return $this;
    }
    /**
     * Get SD_Kenmerk1_NP_MedewerkerTemp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SD_Kenmerk1_NP_MedewerkerTemp|null
     */
    public function getSD_Kenmerk1_NP_MedewerkerTemp()
    {
        return isset($this->SD_Kenmerk1_NP_MedewerkerTemp) ? $this->SD_Kenmerk1_NP_MedewerkerTemp : null;
    }
    /**
     * Set SD_Kenmerk1_NP_MedewerkerTemp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SD_Kenmerk1_NP_MedewerkerTemp $sD_Kenmerk1_NP_MedewerkerTemp
     * @return \StructType\MedewerkerTemp
     */
    public function setSD_Kenmerk1_NP_MedewerkerTemp(\StructType\SD_Kenmerk1_NP_MedewerkerTemp $sD_Kenmerk1_NP_MedewerkerTemp = null)
    {
        if (is_null($sD_Kenmerk1_NP_MedewerkerTemp) || (is_array($sD_Kenmerk1_NP_MedewerkerTemp) && empty($sD_Kenmerk1_NP_MedewerkerTemp))) {
            unset($this->SD_Kenmerk1_NP_MedewerkerTemp);
        } else {
            $this->SD_Kenmerk1_NP_MedewerkerTemp = $sD_Kenmerk1_NP_MedewerkerTemp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MedewerkerTemp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
