<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sollicitatie ServiceType
 * @subpackage Services
 */
class Sollicitatie extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'https://daywize.mendixcloud.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SollicitatieWebservicesVerwerken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee is het mogelijk sollicitaties en open sollicitaties door te geven aan Daywize Cloud. Bij het pushen van de gegevens wordt gecontroleerd of de verplichte velden zijn gevuld. Welke velden verplicht zijn, kan de klant zelf
     * inrichten. De response geeft true of false terug. Indien het false is krijg je ofwel een XML error (bericht is fout) of een mededeling waarom het niet gelukt is.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SollicitatieWebservicesVerwerken $parameters
     * @return \StructType\SollicitatieWebservicesVerwerkenResponse|bool
     */
    public function SollicitatieWebservicesVerwerken(\StructType\SollicitatieWebservicesVerwerken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SollicitatieWebservicesVerwerken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SollicitatieWebservicesVerwerkenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
