<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Jobalerts ServiceType
 * @subpackage Services
 */
class Jobalerts extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'https://daywize.mendixcloud.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named JobalertsVerwerken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee is het mogelijk jobalerts door te geven aan Daywize Cloud. Ook is het mogelijk een jobalert stop te zetten. Bij een jobalert kan de sollicitant keuzes maken uit 2 tabellen: kenmerk 1 en kenmerk 2. De response geeft true of
     * false terug. Indien het false is krijg je ofwel een XML error (bericht is fout) of een mededeling waarom het niet gelukt is.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\JobalertsVerwerken $parameters
     * @return \StructType\JobalertsVerwerkenResponse|bool
     */
    public function JobalertsVerwerken(\StructType\JobalertsVerwerken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->JobalertsVerwerken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\JobalertsVerwerkenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
