<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Geef ServiceType
 * @subpackage Services
 */
class Geef extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'https://daywize.mendixcloud.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelInstroomkanaal
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call SollicitatieWebservicesVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelInstroomkanaal $parameters
     * @return \StructType\GeefWaardenTabelInstroomkanaalResponse|bool
     */
    public function GeefWaardenTabelInstroomkanaal(\StructType\GeefWaardenTabelInstroomkanaal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelInstroomkanaal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelCriteria
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call SollicitatieWebservicesVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelCriteria $parameters
     * @return \StructType\GeefWaardenTabelCriteriaResponse|bool
     */
    public function GeefWaardenTabelCriteria(\StructType\GeefWaardenTabelCriteria $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelCriteria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelOpleidingsniveau
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call SollicitatieWebservicesVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelOpleidingsniveau $parameters
     * @return \StructType\GeefWaardenTabelOpleidingsniveauResponse|bool
     */
    public function GeefWaardenTabelOpleidingsniveau(\StructType\GeefWaardenTabelOpleidingsniveau $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelOpleidingsniveau($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelWerkervaring
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call SollicitatieWebservicesVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelWerkervaring $parameters
     * @return \StructType\GeefWaardenTabelWerkervaringResponse|bool
     */
    public function GeefWaardenTabelWerkervaring(\StructType\GeefWaardenTabelWerkervaring $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelWerkervaring($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelKenmerk1
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call JobalertsVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelKenmerk1 $parameters
     * @return \StructType\GeefWaardenTabelKenmerk1Response|bool
     */
    public function GeefWaardenTabelKenmerk1(\StructType\GeefWaardenTabelKenmerk1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelKenmerk1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeefWaardenTabelKenmerk2
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: https://daywize.mendixcloud.com
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Hiermee krijg je de tabelwaarden terug. Alleen actieve waarden worden aangeboden. De code moet gebruikt worden bij de call JobalertsVerwerken.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeefWaardenTabelKenmerk2 $parameters
     * @return \StructType\GeefWaardenTabelKenmerk2Response|bool
     */
    public function GeefWaardenTabelKenmerk2(\StructType\GeefWaardenTabelKenmerk2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GeefWaardenTabelKenmerk2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GeefWaardenTabelCriteriaResponse|\StructType\GeefWaardenTabelInstroomkanaalResponse|\StructType\GeefWaardenTabelKenmerk1Response|\StructType\GeefWaardenTabelKenmerk2Response|\StructType\GeefWaardenTabelOpleidingsniveauResponse|\StructType\GeefWaardenTabelWerkervaringResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
