<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api-preprod.dynafleetonline.com/wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api-preprod.dynafleetonline.com/wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getDeletedServicePlans operation/method
 */
if ($get->getDeletedServicePlans(new \StructType\GetDeletedServicePlans()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedServicePlans operation/method
 */
if ($get->getModifiedServicePlans(new \StructType\GetModifiedServicePlans()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServicePlan operation/method
 */
if ($get->getServicePlan(new \StructType\GetServicePlan()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCompletedOrders operation/method
 */
if ($get->getCompletedOrders(new \StructType\GetCompletedOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCoveredDistanceFromStatus operation/method
 */
if ($get->getCoveredDistanceFromStatus(new \StructType\GetCoveredDistanceFromStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCreatedOrders operation/method
 */
if ($get->getCreatedOrders(new \StructType\GetCreatedOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomerOrder operation/method
 */
if ($get->getCustomerOrder(new \StructType\GetCustomerOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomerOrders operation/method
 */
if ($get->getCustomerOrders(new \StructType\GetCustomerOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedOrders operation/method
 */
if ($get->getDeletedOrders(new \StructType\GetDeletedOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getElapsedTimeFromStatus operation/method
 */
if ($get->getElapsedTimeFromStatus(new \StructType\GetElapsedTimeFromStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFuelConsumptionFromStatus operation/method
 */
if ($get->getFuelConsumptionFromStatus(new \StructType\GetFuelConsumptionFromStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMinimumOrder operation/method
 */
if ($get->getMinimumOrder(new \StructType\GetMinimumOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedOrderItems operation/method
 */
if ($get->getModifiedOrderItems(new \StructType\GetModifiedOrderItems()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrder operation/method
 */
if ($get->getOrder(new \StructType\GetOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrderItem operation/method
 */
if ($get->getOrderItem(new \StructType\GetOrderItem()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrdersMarkedAsRead operation/method
 */
if ($get->getOrdersMarkedAsRead(new \StructType\GetOrdersMarkedAsRead()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomer operation/method
 */
if ($get->getCustomer(new \StructType\GetCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomers operation/method
 */
if ($get->getCustomers(new \StructType\GetCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedCustomers operation/method
 */
if ($get->getDeletedCustomers(new \StructType\GetDeletedCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedCustomers operation/method
 */
if ($get->getModifiedCustomers(new \StructType\GetModifiedCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAlarms operation/method
 */
if ($get->getAlarms(new \StructType\GetAlarms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedAlarms operation/method
 */
if ($get->getDeletedAlarms(new \StructType\GetDeletedAlarms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedMessages operation/method
 */
if ($get->getDeletedMessages(new \StructType\GetDeletedMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMessageReadAckInfos operation/method
 */
if ($get->getMessageReadAckInfos(new \StructType\GetMessageReadAckInfos()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMessagesInInbox operation/method
 */
if ($get->getMessagesInInbox(new \StructType\GetMessagesInInbox()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicleEventMessages operation/method
 */
if ($get->getVehicleEventMessages(new \StructType\GetVehicleEventMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewAlarms operation/method
 */
if ($get->getNewAlarms(new \StructType\GetNewAlarms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewMessages operation/method
 */
if ($get->getNewMessages(new \StructType\GetNewMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewVehicleEventMessages operation/method
 */
if ($get->getNewVehicleEventMessages(new \StructType\GetNewVehicleEventMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewMessagesSendstatus operation/method
 */
if ($get->getNewMessagesSendstatus(new \StructType\GetNewMessagesSendstatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriverReportData operation/method
 */
if ($get->getDriverReportData(new \StructType\GetDriverReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDtjReportData operation/method
 */
if ($get->getDtjReportData(new \StructType\GetDtjReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewDriverReportData operation/method
 */
if ($get->getNewDriverReportData(new \StructType\GetNewDriverReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewDtjReportData operation/method
 */
if ($get->getNewDtjReportData(new \StructType\GetNewDtjReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewVehicleReportData operation/method
 */
if ($get->getNewVehicleReportData(new \StructType\GetNewVehicleReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewVehicleReportDataExtended operation/method
 */
if ($get->getNewVehicleReportDataExtended(new \StructType\GetNewVehicleReportDataExtended()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicleReportData operation/method
 */
if ($get->getVehicleReportData(new \StructType\GetVehicleReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicleReportDataExtended operation/method
 */
if ($get->getVehicleReportDataExtended(new \StructType\GetVehicleReportDataExtended()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedPois operation/method
 */
if ($get->getDeletedPois(new \StructType\GetDeletedPois()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedPois operation/method
 */
if ($get->getModifiedPois(new \StructType\GetModifiedPois()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoi operation/method
 */
if ($get->getPoi(new \StructType\GetPoi()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPois operation/method
 */
if ($get->getPois(new \StructType\GetPois()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoisByBoundingBox operation/method
 */
if ($get->getPoisByBoundingBox(new \StructType\GetPoisByBoundingBox()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoisByType operation/method
 */
if ($get->getPoisByType(new \StructType\GetPoisByType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPoisByTypeAndBoundingBox operation/method
 */
if ($get->getPoisByTypeAndBoundingBox(new \StructType\GetPoisByTypeAndBoundingBox()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedDrivers operation/method
 */
if ($get->getDeletedDrivers(new \StructType\GetDeletedDrivers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedUsers operation/method
 */
if ($get->getDeletedUsers(new \StructType\GetDeletedUsers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedVehicles operation/method
 */
if ($get->getDeletedVehicles(new \StructType\GetDeletedVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriver operation/method
 */
if ($get->getDriver(new \StructType\GetDriver()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriverV2 operation/method
 */
if ($get->getDriverV2(new \StructType\GetDriverV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDrivers operation/method
 */
if ($get->getDrivers(new \StructType\GetDrivers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriversV2 operation/method
 */
if ($get->getDriversV2(new \StructType\GetDriversV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriverTimes operation/method
 */
if ($get->getDriverTimes(new \StructType\GetDriverTimes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFleetInfo operation/method
 */
if ($get->getFleetInfo(new \StructType\GetFleetInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedDrivers operation/method
 */
if ($get->getModifiedDrivers(new \StructType\GetModifiedDrivers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedUsers operation/method
 */
if ($get->getModifiedUsers(new \StructType\GetModifiedUsers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedVehicles operation/method
 */
if ($get->getModifiedVehicles(new \StructType\GetModifiedVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUsers operation/method
 */
if ($get->getUsers(new \StructType\GetUsers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUsersAssignedToVehicle operation/method
 */
if ($get->getUsersAssignedToVehicle(new \StructType\GetUsersAssignedToVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicle operation/method
 */
if ($get->getVehicle(new \StructType\GetVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehicles operation/method
 */
if ($get->getVehicles(new \StructType\GetVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehiclesV2 operation/method
 */
if ($get->getVehiclesV2(new \StructType\GetVehiclesV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getForm operation/method
 */
if ($get->getForm(new \StructType\GetForm()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getForms operation/method
 */
if ($get->getForms(new \StructType\GetForms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormsInVehicle operation/method
 */
if ($get->getFormsInVehicle(new \StructType\GetFormsInVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewPositions operation/method
 */
if ($get->getNewPositions(new \StructType\GetNewPositions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewTrackingData operation/method
 */
if ($get->getNewTrackingData(new \StructType\GetNewTrackingData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewTrackingDataV2 operation/method
 */
if ($get->getNewTrackingDataV2(new \StructType\GetNewTrackingDataV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewTrackingDataWithETAInfo operation/method
 */
if ($get->getNewTrackingDataWithETAInfo(new \StructType\GetNewTrackingDataWithETAInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehiclePositions operation/method
 */
if ($get->getVehiclePositions(new \StructType\GetVehiclePositions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLastKnownPositions operation/method
 */
if ($get->getLastKnownPositions(new \StructType\GetLastKnownPositions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDTMAlarmSetting operation/method
 */
if ($get->getDTMAlarmSetting(new \StructType\GetDTMAlarmSetting()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDTMAlarmsForVehicle operation/method
 */
if ($get->getDTMAlarmsForVehicle(new \StructType\GetDTMAlarmsForVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedDTMAlarms operation/method
 */
if ($get->getDeletedDTMAlarms(new \StructType\GetDeletedDTMAlarms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewDTMAlarmSetupSendStatuses operation/method
 */
if ($get->getNewDTMAlarmSetupSendStatuses(new \StructType\GetNewDTMAlarmSetupSendStatuses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewDTMAlarms operation/method
 */
if ($get->getNewDTMAlarms(new \StructType\GetNewDTMAlarms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedFormMessages operation/method
 */
if ($get->getDeletedFormMessages(new \StructType\GetDeletedFormMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormMessageReadAckInfos operation/method
 */
if ($get->getFormMessageReadAckInfos(new \StructType\GetFormMessageReadAckInfos()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormMessagesByForm operation/method
 */
if ($get->getFormMessagesByForm(new \StructType\GetFormMessagesByForm()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFormMessagesInInbox operation/method
 */
if ($get->getFormMessagesInInbox(new \StructType\GetFormMessagesInInbox()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewFormMessageSendstatus operation/method
 */
if ($get->getNewFormMessageSendstatus(new \StructType\GetNewFormMessageSendstatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewFormMessages operation/method
 */
if ($get->getNewFormMessages(new \StructType\GetNewFormMessages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeofenceData operation/method
 */
if ($get->getGeofenceData(new \StructType\GetGeofenceData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewGeofenceData operation/method
 */
if ($get->getNewGeofenceData(new \StructType\GetNewGeofenceData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedGeofencePlus operation/method
 */
if ($get->getDeletedGeofencePlus(new \StructType\GetDeletedGeofencePlus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeofencePlus operation/method
 */
if ($get->getGeofencePlus(new \StructType\GetGeofencePlus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeofences operation/method
 */
if ($get->getGeofences(new \StructType\GetGeofences()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModifiedGeofencePlus operation/method
 */
if ($get->getModifiedGeofencePlus(new \StructType\GetModifiedGeofencePlus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewGeofencePlusData operation/method
 */
if ($get->getNewGeofencePlusData(new \StructType\GetNewGeofencePlusData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addOrderItem operation/method
 */
if ($add->addOrderItem(new \StructType\AddOrderItem()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
/**
 * Sample call for assignOrderToUser operation/method
 */
if ($assign->assignOrderToUser(new \StructType\AssignOrderToUser()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Sample call for assignOrderToVehicle operation/method
 */
if ($assign->assignOrderToVehicle(new \StructType\AssignOrderToVehicle()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteCompletedOrder operation/method
 */
if ($delete->deleteCompletedOrder(new \StructType\DeleteCompletedOrder()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteOrderItem operation/method
 */
if ($delete->deleteOrderItem(new \StructType\DeleteOrderItem()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteCustomer operation/method
 */
if ($delete->deleteCustomer(new \StructType\DeleteCustomer()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMessage operation/method
 */
if ($delete->deleteMessage(new \StructType\DeleteMessage()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMessagesByTimestamp operation/method
 */
if ($delete->deleteMessagesByTimestamp(new \StructType\DeleteMessagesByTimestamp()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteReadMessages operation/method
 */
if ($delete->deleteReadMessages(new \StructType\DeleteReadMessages()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deletePoi operation/method
 */
if ($delete->deletePoi(new \StructType\DeletePoi()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteFormMessage operation/method
 */
if ($delete->deleteFormMessage(new \StructType\DeleteFormMessage()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteFormMessages operation/method
 */
if ($delete->deleteFormMessages(new \StructType\DeleteFormMessages()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for markOrderAsCompleted operation/method
 */
if ($mark->markOrderAsCompleted(new \StructType\MarkOrderAsCompleted()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markOrderAsRead operation/method
 */
if ($mark->markOrderAsRead(new \StructType\MarkOrderAsRead()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendOrderItemToVehicle operation/method
 */
if ($send->sendOrderItemToVehicle(new \StructType\SendOrderItemToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendOrderToVehicle operation/method
 */
if ($send->sendOrderToVehicle(new \StructType\SendOrderToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendMessageToUser operation/method
 */
if ($send->sendMessageToUser(new \StructType\SendMessageToUser()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendMessageToVehicle operation/method
 */
if ($send->sendMessageToVehicle(new \StructType\SendMessageToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendMessageWithDestinationPointToVehicle operation/method
 */
if ($send->sendMessageWithDestinationPointToVehicle(new \StructType\SendMessageWithDestinationPointToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendFormMessageToVehicle operation/method
 */
if ($send->sendFormMessageToVehicle(new \StructType\SendFormMessageToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendFormMessageWithDestinationPointToVehicle operation/method
 */
if ($send->sendFormMessageWithDestinationPointToVehicle(new \StructType\SendFormMessageWithDestinationPointToVehicle()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Store ServiceType
 */
$store = new \ServiceType\Store($options);
/**
 * Sample call for storeNewOrder operation/method
 */
if ($store->storeNewOrder(new \StructType\StoreNewOrder()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeDTMAlarmSetting operation/method
 */
if ($store->storeDTMAlarmSetting(new \StructType\StoreDTMAlarmSetting()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createCustomer operation/method
 */
if ($create->createCustomer(new \StructType\CreateCustomer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPoi operation/method
 */
if ($create->createPoi(new \StructType\CreatePoi()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createGeofencePlus operation/method
 */
if ($create->createGeofencePlus(new \StructType\CreateGeofencePlus()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for modifyCustomer operation/method
 */
if ($modify->modifyCustomer(new \StructType\ModifyCustomer()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyPoi operation/method
 */
if ($modify->modifyPoi(new \StructType\ModifyPoi()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyGeofencePlus operation/method
 */
if ($modify->modifyGeofencePlus(new \StructType\ModifyGeofencePlus()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkNotificationFlags operation/method
 */
if ($check->checkNotificationFlags(new \StructType\CheckNotificationFlags()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkNotificationFlags2 operation/method
 */
if ($check->checkNotificationFlags2(new \StructType\CheckNotificationFlags2()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkNotificationFlags3 operation/method
 */
if ($check->checkNotificationFlags3(new \StructType\CheckNotificationFlags3()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for setAutoDeleteMessage operation/method
 */
if ($set->setAutoDeleteMessage(new \StructType\SetAutoDeleteMessage()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \ServiceType\Make($options);
/**
 * Sample call for makeManualDownload operation/method
 */
if ($make->makeManualDownload(new \StructType\MakeManualDownload()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for Request ServiceType
 */
$request = new \ServiceType\Request($options);
/**
 * Sample call for requestVehiclePosition operation/method
 */
if ($request->requestVehiclePosition(new \StructType\RequestVehiclePosition()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
