<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExceptionInformation StructType
 * @subpackage Structs
 */
class ExceptionInformation extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The errorCode
     * @var int
     */
    public $errorCode;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $id;
    /**
     * The originalException
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $originalException;
    /**
     * The originalMessage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $originalMessage;
    /**
     * The shortDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shortDescription;
    /**
     * Constructor method for ExceptionInformation
     * @uses ExceptionInformation::setDescription()
     * @uses ExceptionInformation::setErrorCode()
     * @uses ExceptionInformation::setId()
     * @uses ExceptionInformation::setOriginalException()
     * @uses ExceptionInformation::setOriginalMessage()
     * @uses ExceptionInformation::setShortDescription()
     * @param string $description
     * @param int $errorCode
     * @param string $id
     * @param string $originalException
     * @param string $originalMessage
     * @param string $shortDescription
     */
    public function __construct($description = null, $errorCode = null, $id = null, $originalException = null, $originalMessage = null, $shortDescription = null)
    {
        $this
            ->setDescription($description)
            ->setErrorCode($errorCode)
            ->setId($id)
            ->setOriginalException($originalException)
            ->setOriginalMessage($originalMessage)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExceptionInformation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\ExceptionInformation
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ExceptionInformation
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get originalException value
     * @return string|null
     */
    public function getOriginalException()
    {
        return $this->originalException;
    }
    /**
     * Set originalException value
     * @param string $originalException
     * @return \StructType\ExceptionInformation
     */
    public function setOriginalException($originalException = null)
    {
        // validation for constraint: string
        if (!is_null($originalException) && !is_string($originalException)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalException)), __LINE__);
        }
        $this->originalException = $originalException;
        return $this;
    }
    /**
     * Get originalMessage value
     * @return string|null
     */
    public function getOriginalMessage()
    {
        return $this->originalMessage;
    }
    /**
     * Set originalMessage value
     * @param string $originalMessage
     * @return \StructType\ExceptionInformation
     */
    public function setOriginalMessage($originalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($originalMessage) && !is_string($originalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalMessage)), __LINE__);
        }
        $this->originalMessage = $originalMessage;
        return $this;
    }
    /**
     * Get shortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }
    /**
     * Set shortDescription value
     * @param string $shortDescription
     * @return \StructType\ExceptionInformation
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortDescription)), __LINE__);
        }
        $this->shortDescription = $shortDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExceptionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
