<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_ServicePlanEntryTO StructType
 * @subpackage Structs
 */
class Api_ServicePlanEntryTO extends AbstractStructBase
{
    /**
     * The hasOdometerAlert
     * @var bool
     */
    public $hasOdometerAlert;
    /**
     * The hasOverdueAlert
     * @var bool
     */
    public $hasOverdueAlert;
    /**
     * The mileage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $mileage;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $operation;
    /**
     * The serviceDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $serviceDate;
    /**
     * The servicePlanEntryId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $servicePlanEntryId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The vehicleId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_VehicleId
     */
    public $vehicleId;
    /**
     * The vospCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vospCode;
    /**
     * The vospOriginated
     * @var bool
     */
    public $vospOriginated;
    /**
     * Constructor method for Api_ServicePlanEntryTO
     * @uses Api_ServicePlanEntryTO::setHasOdometerAlert()
     * @uses Api_ServicePlanEntryTO::setHasOverdueAlert()
     * @uses Api_ServicePlanEntryTO::setMileage()
     * @uses Api_ServicePlanEntryTO::setOperation()
     * @uses Api_ServicePlanEntryTO::setServiceDate()
     * @uses Api_ServicePlanEntryTO::setServicePlanEntryId()
     * @uses Api_ServicePlanEntryTO::setStatus()
     * @uses Api_ServicePlanEntryTO::setVehicleId()
     * @uses Api_ServicePlanEntryTO::setVospCode()
     * @uses Api_ServicePlanEntryTO::setVospOriginated()
     * @param bool $hasOdometerAlert
     * @param bool $hasOverdueAlert
     * @param \StructType\Api_Long $mileage
     * @param string $operation
     * @param \StructType\Api_Date $serviceDate
     * @param \StructType\Api_Long $servicePlanEntryId
     * @param string $status
     * @param \StructType\Api_VehicleId $vehicleId
     * @param string $vospCode
     * @param bool $vospOriginated
     */
    public function __construct($hasOdometerAlert = null, $hasOverdueAlert = null, \StructType\Api_Long $mileage = null, $operation = null, \StructType\Api_Date $serviceDate = null, \StructType\Api_Long $servicePlanEntryId = null, $status = null, \StructType\Api_VehicleId $vehicleId = null, $vospCode = null, $vospOriginated = null)
    {
        $this
            ->setHasOdometerAlert($hasOdometerAlert)
            ->setHasOverdueAlert($hasOverdueAlert)
            ->setMileage($mileage)
            ->setOperation($operation)
            ->setServiceDate($serviceDate)
            ->setServicePlanEntryId($servicePlanEntryId)
            ->setStatus($status)
            ->setVehicleId($vehicleId)
            ->setVospCode($vospCode)
            ->setVospOriginated($vospOriginated);
    }
    /**
     * Get hasOdometerAlert value
     * @return bool|null
     */
    public function getHasOdometerAlert()
    {
        return $this->hasOdometerAlert;
    }
    /**
     * Set hasOdometerAlert value
     * @param bool $hasOdometerAlert
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setHasOdometerAlert($hasOdometerAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOdometerAlert) && !is_bool($hasOdometerAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasOdometerAlert)), __LINE__);
        }
        $this->hasOdometerAlert = $hasOdometerAlert;
        return $this;
    }
    /**
     * Get hasOverdueAlert value
     * @return bool|null
     */
    public function getHasOverdueAlert()
    {
        return $this->hasOverdueAlert;
    }
    /**
     * Set hasOverdueAlert value
     * @param bool $hasOverdueAlert
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setHasOverdueAlert($hasOverdueAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOverdueAlert) && !is_bool($hasOverdueAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasOverdueAlert)), __LINE__);
        }
        $this->hasOverdueAlert = $hasOverdueAlert;
        return $this;
    }
    /**
     * Get mileage value
     * @return \StructType\Api_Long|null
     */
    public function getMileage()
    {
        return $this->mileage;
    }
    /**
     * Set mileage value
     * @param \StructType\Api_Long $mileage
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setMileage(\StructType\Api_Long $mileage = null)
    {
        $this->mileage = $mileage;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get serviceDate value
     * @return \StructType\Api_Date|null
     */
    public function getServiceDate()
    {
        return $this->serviceDate;
    }
    /**
     * Set serviceDate value
     * @param \StructType\Api_Date $serviceDate
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setServiceDate(\StructType\Api_Date $serviceDate = null)
    {
        $this->serviceDate = $serviceDate;
        return $this;
    }
    /**
     * Get servicePlanEntryId value
     * @return \StructType\Api_Long|null
     */
    public function getServicePlanEntryId()
    {
        return $this->servicePlanEntryId;
    }
    /**
     * Set servicePlanEntryId value
     * @param \StructType\Api_Long $servicePlanEntryId
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setServicePlanEntryId(\StructType\Api_Long $servicePlanEntryId = null)
    {
        $this->servicePlanEntryId = $servicePlanEntryId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get vehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param \StructType\Api_VehicleId $vehicleId
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setVehicleId(\StructType\Api_VehicleId $vehicleId = null)
    {
        $this->vehicleId = $vehicleId;
        return $this;
    }
    /**
     * Get vospCode value
     * @return string|null
     */
    public function getVospCode()
    {
        return $this->vospCode;
    }
    /**
     * Set vospCode value
     * @param string $vospCode
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setVospCode($vospCode = null)
    {
        // validation for constraint: string
        if (!is_null($vospCode) && !is_string($vospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vospCode)), __LINE__);
        }
        $this->vospCode = $vospCode;
        return $this;
    }
    /**
     * Get vospOriginated value
     * @return bool|null
     */
    public function getVospOriginated()
    {
        return $this->vospOriginated;
    }
    /**
     * Set vospOriginated value
     * @param bool $vospOriginated
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public function setVospOriginated($vospOriginated = null)
    {
        // validation for constraint: boolean
        if (!is_null($vospOriginated) && !is_bool($vospOriginated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vospOriginated)), __LINE__);
        }
        $this->vospOriginated = $vospOriginated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_ServicePlanEntryTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
