<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderTO StructType
 * @subpackage Structs
 */
class Api_OrderTO extends AbstractStructBase
{
    /**
     * The assignedUserId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_UserId
     */
    public $assignedUserId;
    /**
     * The assignedVehicleId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_VehicleId
     */
    public $assignedVehicleId;
    /**
     * The completedTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $completedTime;
    /**
     * The createTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $createTime;
    /**
     * The customerDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $customerDescription;
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Long
     */
    public $customerId;
    /**
     * The deletedTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $deletedTime;
    /**
     * The driverDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $driverDescription;
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $driverId;
    /**
     * The isRead
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $isRead;
    /**
     * The lastModifyTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $lastModifyTime;
    /**
     * The orderCustomerRef
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderCustomerRef;
    /**
     * The orderItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_OrderItemTO[]
     */
    public $orderItems;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $orderNumber;
    /**
     * The userDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userDescription;
    /**
     * The vehicleDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vehicleDescription;
    /**
     * Constructor method for Api_OrderTO
     * @uses Api_OrderTO::setAssignedUserId()
     * @uses Api_OrderTO::setAssignedVehicleId()
     * @uses Api_OrderTO::setCompletedTime()
     * @uses Api_OrderTO::setCreateTime()
     * @uses Api_OrderTO::setCustomerDescription()
     * @uses Api_OrderTO::setCustomerId()
     * @uses Api_OrderTO::setDeletedTime()
     * @uses Api_OrderTO::setDriverDescription()
     * @uses Api_OrderTO::setDriverId()
     * @uses Api_OrderTO::setIsRead()
     * @uses Api_OrderTO::setLastModifyTime()
     * @uses Api_OrderTO::setOrderCustomerRef()
     * @uses Api_OrderTO::setOrderItems()
     * @uses Api_OrderTO::setOrderNumber()
     * @uses Api_OrderTO::setUserDescription()
     * @uses Api_OrderTO::setVehicleDescription()
     * @param \StructType\Api_UserId $assignedUserId
     * @param \StructType\Api_VehicleId $assignedVehicleId
     * @param \StructType\Api_Date $completedTime
     * @param \StructType\Api_Date $createTime
     * @param string $customerDescription
     * @param \StructType\Api_Long $customerId
     * @param \StructType\Api_Date $deletedTime
     * @param string $driverDescription
     * @param \StructType\Api_Long $driverId
     * @param \StructType\Api_Boolean $isRead
     * @param \StructType\Api_Date $lastModifyTime
     * @param string $orderCustomerRef
     * @param \StructType\Api_OrderItemTO[] $orderItems
     * @param string $orderNumber
     * @param string $userDescription
     * @param string $vehicleDescription
     */
    public function __construct(\StructType\Api_UserId $assignedUserId = null, \StructType\Api_VehicleId $assignedVehicleId = null, \StructType\Api_Date $completedTime = null, \StructType\Api_Date $createTime = null, $customerDescription = null, \StructType\Api_Long $customerId = null, \StructType\Api_Date $deletedTime = null, $driverDescription = null, \StructType\Api_Long $driverId = null, \StructType\Api_Boolean $isRead = null, \StructType\Api_Date $lastModifyTime = null, $orderCustomerRef = null, array $orderItems = array(), $orderNumber = null, $userDescription = null, $vehicleDescription = null)
    {
        $this
            ->setAssignedUserId($assignedUserId)
            ->setAssignedVehicleId($assignedVehicleId)
            ->setCompletedTime($completedTime)
            ->setCreateTime($createTime)
            ->setCustomerDescription($customerDescription)
            ->setCustomerId($customerId)
            ->setDeletedTime($deletedTime)
            ->setDriverDescription($driverDescription)
            ->setDriverId($driverId)
            ->setIsRead($isRead)
            ->setLastModifyTime($lastModifyTime)
            ->setOrderCustomerRef($orderCustomerRef)
            ->setOrderItems($orderItems)
            ->setOrderNumber($orderNumber)
            ->setUserDescription($userDescription)
            ->setVehicleDescription($vehicleDescription);
    }
    /**
     * Get assignedUserId value
     * @return \StructType\Api_UserId|null
     */
    public function getAssignedUserId()
    {
        return $this->assignedUserId;
    }
    /**
     * Set assignedUserId value
     * @param \StructType\Api_UserId $assignedUserId
     * @return \StructType\Api_OrderTO
     */
    public function setAssignedUserId(\StructType\Api_UserId $assignedUserId = null)
    {
        $this->assignedUserId = $assignedUserId;
        return $this;
    }
    /**
     * Get assignedVehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getAssignedVehicleId()
    {
        return $this->assignedVehicleId;
    }
    /**
     * Set assignedVehicleId value
     * @param \StructType\Api_VehicleId $assignedVehicleId
     * @return \StructType\Api_OrderTO
     */
    public function setAssignedVehicleId(\StructType\Api_VehicleId $assignedVehicleId = null)
    {
        $this->assignedVehicleId = $assignedVehicleId;
        return $this;
    }
    /**
     * Get completedTime value
     * @return \StructType\Api_Date|null
     */
    public function getCompletedTime()
    {
        return $this->completedTime;
    }
    /**
     * Set completedTime value
     * @param \StructType\Api_Date $completedTime
     * @return \StructType\Api_OrderTO
     */
    public function setCompletedTime(\StructType\Api_Date $completedTime = null)
    {
        $this->completedTime = $completedTime;
        return $this;
    }
    /**
     * Get createTime value
     * @return \StructType\Api_Date|null
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }
    /**
     * Set createTime value
     * @param \StructType\Api_Date $createTime
     * @return \StructType\Api_OrderTO
     */
    public function setCreateTime(\StructType\Api_Date $createTime = null)
    {
        $this->createTime = $createTime;
        return $this;
    }
    /**
     * Get customerDescription value
     * @return string|null
     */
    public function getCustomerDescription()
    {
        return $this->customerDescription;
    }
    /**
     * Set customerDescription value
     * @param string $customerDescription
     * @return \StructType\Api_OrderTO
     */
    public function setCustomerDescription($customerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customerDescription) && !is_string($customerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerDescription)), __LINE__);
        }
        $this->customerDescription = $customerDescription;
        return $this;
    }
    /**
     * Get customerId value
     * @return \StructType\Api_Long|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param \StructType\Api_Long $customerId
     * @return \StructType\Api_OrderTO
     */
    public function setCustomerId(\StructType\Api_Long $customerId = null)
    {
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get deletedTime value
     * @return \StructType\Api_Date|null
     */
    public function getDeletedTime()
    {
        return $this->deletedTime;
    }
    /**
     * Set deletedTime value
     * @param \StructType\Api_Date $deletedTime
     * @return \StructType\Api_OrderTO
     */
    public function setDeletedTime(\StructType\Api_Date $deletedTime = null)
    {
        $this->deletedTime = $deletedTime;
        return $this;
    }
    /**
     * Get driverDescription value
     * @return string|null
     */
    public function getDriverDescription()
    {
        return $this->driverDescription;
    }
    /**
     * Set driverDescription value
     * @param string $driverDescription
     * @return \StructType\Api_OrderTO
     */
    public function setDriverDescription($driverDescription = null)
    {
        // validation for constraint: string
        if (!is_null($driverDescription) && !is_string($driverDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverDescription)), __LINE__);
        }
        $this->driverDescription = $driverDescription;
        return $this;
    }
    /**
     * Get driverId value
     * @return \StructType\Api_Long|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param \StructType\Api_Long $driverId
     * @return \StructType\Api_OrderTO
     */
    public function setDriverId(\StructType\Api_Long $driverId = null)
    {
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get isRead value
     * @return \StructType\Api_Boolean|null
     */
    public function getIsRead()
    {
        return $this->isRead;
    }
    /**
     * Set isRead value
     * @param \StructType\Api_Boolean $isRead
     * @return \StructType\Api_OrderTO
     */
    public function setIsRead(\StructType\Api_Boolean $isRead = null)
    {
        $this->isRead = $isRead;
        return $this;
    }
    /**
     * Get lastModifyTime value
     * @return \StructType\Api_Date|null
     */
    public function getLastModifyTime()
    {
        return $this->lastModifyTime;
    }
    /**
     * Set lastModifyTime value
     * @param \StructType\Api_Date $lastModifyTime
     * @return \StructType\Api_OrderTO
     */
    public function setLastModifyTime(\StructType\Api_Date $lastModifyTime = null)
    {
        $this->lastModifyTime = $lastModifyTime;
        return $this;
    }
    /**
     * Get orderCustomerRef value
     * @return string|null
     */
    public function getOrderCustomerRef()
    {
        return $this->orderCustomerRef;
    }
    /**
     * Set orderCustomerRef value
     * @param string $orderCustomerRef
     * @return \StructType\Api_OrderTO
     */
    public function setOrderCustomerRef($orderCustomerRef = null)
    {
        // validation for constraint: string
        if (!is_null($orderCustomerRef) && !is_string($orderCustomerRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCustomerRef)), __LINE__);
        }
        $this->orderCustomerRef = $orderCustomerRef;
        return $this;
    }
    /**
     * Get orderItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_OrderItemTO[]|null
     */
    public function getOrderItems()
    {
        return isset($this->orderItems) ? $this->orderItems : null;
    }
    /**
     * Set orderItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderItemTO[] $orderItems
     * @return \StructType\Api_OrderTO
     */
    public function setOrderItems(array $orderItems = array())
    {
        foreach ($orderItems as $api_OrderTOOrderItemsItem) {
            // validation for constraint: itemType
            if (!$api_OrderTOOrderItemsItem instanceof \StructType\Api_OrderItemTO) {
                throw new \InvalidArgumentException(sprintf('The orderItems property can only contain items of \StructType\Api_OrderItemTO, "%s" given', is_object($api_OrderTOOrderItemsItem) ? get_class($api_OrderTOOrderItemsItem) : gettype($api_OrderTOOrderItemsItem)), __LINE__);
            }
        }
        if (is_null($orderItems) || (is_array($orderItems) && empty($orderItems))) {
            unset($this->orderItems);
        } else {
            $this->orderItems = $orderItems;
        }
        return $this;
    }
    /**
     * Add item to orderItems value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderItemTO $item
     * @return \StructType\Api_OrderTO
     */
    public function addToOrderItems(\StructType\Api_OrderItemTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_OrderItemTO) {
            throw new \InvalidArgumentException(sprintf('The orderItems property can only contain items of \StructType\Api_OrderItemTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItems[] = $item;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Api_OrderTO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get userDescription value
     * @return string|null
     */
    public function getUserDescription()
    {
        return $this->userDescription;
    }
    /**
     * Set userDescription value
     * @param string $userDescription
     * @return \StructType\Api_OrderTO
     */
    public function setUserDescription($userDescription = null)
    {
        // validation for constraint: string
        if (!is_null($userDescription) && !is_string($userDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userDescription)), __LINE__);
        }
        $this->userDescription = $userDescription;
        return $this;
    }
    /**
     * Get vehicleDescription value
     * @return string|null
     */
    public function getVehicleDescription()
    {
        return $this->vehicleDescription;
    }
    /**
     * Set vehicleDescription value
     * @param string $vehicleDescription
     * @return \StructType\Api_OrderTO
     */
    public function setVehicleDescription($vehicleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleDescription) && !is_string($vehicleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleDescription)), __LINE__);
        }
        $this->vehicleDescription = $vehicleDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
