<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderGetCustomerOrderTO StructType
 * @subpackage Structs
 */
class Api_OrderGetCustomerOrderTO extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_TransportCustomerId
     */
    public $customerId;
    /**
     * The orderCustomerRef
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $orderCustomerRef;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_SessionId
     */
    public $sessionId;
    /**
     * Constructor method for Api_OrderGetCustomerOrderTO
     * @uses Api_OrderGetCustomerOrderTO::setCustomerId()
     * @uses Api_OrderGetCustomerOrderTO::setOrderCustomerRef()
     * @uses Api_OrderGetCustomerOrderTO::setSessionId()
     * @param \StructType\Api_TransportCustomerId $customerId
     * @param string $orderCustomerRef
     * @param \StructType\Api_SessionId $sessionId
     */
    public function __construct(\StructType\Api_TransportCustomerId $customerId = null, $orderCustomerRef = null, \StructType\Api_SessionId $sessionId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setOrderCustomerRef($orderCustomerRef)
            ->setSessionId($sessionId);
    }
    /**
     * Get customerId value
     * @return \StructType\Api_TransportCustomerId|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param \StructType\Api_TransportCustomerId $customerId
     * @return \StructType\Api_OrderGetCustomerOrderTO
     */
    public function setCustomerId(\StructType\Api_TransportCustomerId $customerId = null)
    {
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get orderCustomerRef value
     * @return string|null
     */
    public function getOrderCustomerRef()
    {
        return $this->orderCustomerRef;
    }
    /**
     * Set orderCustomerRef value
     * @param string $orderCustomerRef
     * @return \StructType\Api_OrderGetCustomerOrderTO
     */
    public function setOrderCustomerRef($orderCustomerRef = null)
    {
        // validation for constraint: string
        if (!is_null($orderCustomerRef) && !is_string($orderCustomerRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCustomerRef)), __LINE__);
        }
        $this->orderCustomerRef = $orderCustomerRef;
        return $this;
    }
    /**
     * Get sessionId value
     * @return \StructType\Api_SessionId|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param \StructType\Api_SessionId $sessionId
     * @return \StructType\Api_OrderGetCustomerOrderTO
     */
    public function setSessionId(\StructType\Api_SessionId $sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderGetCustomerOrderTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
