<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_FormTO StructType
 * @subpackage Structs
 */
class Api_FormTO extends AbstractStructBase
{
    /**
     * The deleted
     * @var bool
     */
    public $deleted;
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $displayName;
    /**
     * The formFields
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\Api_FormFieldArrayTO
     */
    public $formFields;
    /**
     * The formId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_FormId
     */
    public $formId;
    /**
     * The formIsUsed
     * @var bool
     */
    public $formIsUsed;
    /**
     * The messageForm
     * @var bool
     */
    public $messageForm;
    /**
     * Constructor method for Api_FormTO
     * @uses Api_FormTO::setDeleted()
     * @uses Api_FormTO::setDisplayName()
     * @uses Api_FormTO::setFormFields()
     * @uses Api_FormTO::setFormId()
     * @uses Api_FormTO::setFormIsUsed()
     * @uses Api_FormTO::setMessageForm()
     * @param bool $deleted
     * @param string $displayName
     * @param \ArrayType\Api_FormFieldArrayTO $formFields
     * @param \StructType\Api_FormId $formId
     * @param bool $formIsUsed
     * @param bool $messageForm
     */
    public function __construct($deleted = null, $displayName = null, \ArrayType\Api_FormFieldArrayTO $formFields = null, \StructType\Api_FormId $formId = null, $formIsUsed = null, $messageForm = null)
    {
        $this
            ->setDeleted($deleted)
            ->setDisplayName($displayName)
            ->setFormFields($formFields)
            ->setFormId($formId)
            ->setFormIsUsed($formIsUsed)
            ->setMessageForm($messageForm);
    }
    /**
     * Get deleted value
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Set deleted value
     * @param bool $deleted
     * @return \StructType\Api_FormTO
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($deleted) && !is_bool($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deleted)), __LINE__);
        }
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\Api_FormTO
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get formFields value
     * @return \ArrayType\Api_FormFieldArrayTO|null
     */
    public function getFormFields()
    {
        return $this->formFields;
    }
    /**
     * Set formFields value
     * @param \ArrayType\Api_FormFieldArrayTO $formFields
     * @return \StructType\Api_FormTO
     */
    public function setFormFields(\ArrayType\Api_FormFieldArrayTO $formFields = null)
    {
        $this->formFields = $formFields;
        return $this;
    }
    /**
     * Get formId value
     * @return \StructType\Api_FormId|null
     */
    public function getFormId()
    {
        return $this->formId;
    }
    /**
     * Set formId value
     * @param \StructType\Api_FormId $formId
     * @return \StructType\Api_FormTO
     */
    public function setFormId(\StructType\Api_FormId $formId = null)
    {
        $this->formId = $formId;
        return $this;
    }
    /**
     * Get formIsUsed value
     * @return bool|null
     */
    public function getFormIsUsed()
    {
        return $this->formIsUsed;
    }
    /**
     * Set formIsUsed value
     * @param bool $formIsUsed
     * @return \StructType\Api_FormTO
     */
    public function setFormIsUsed($formIsUsed = null)
    {
        // validation for constraint: boolean
        if (!is_null($formIsUsed) && !is_bool($formIsUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($formIsUsed)), __LINE__);
        }
        $this->formIsUsed = $formIsUsed;
        return $this;
    }
    /**
     * Get messageForm value
     * @return bool|null
     */
    public function getMessageForm()
    {
        return $this->messageForm;
    }
    /**
     * Set messageForm value
     * @param bool $messageForm
     * @return \StructType\Api_FormTO
     */
    public function setMessageForm($messageForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($messageForm) && !is_bool($messageForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($messageForm)), __LINE__);
        }
        $this->messageForm = $messageForm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_FormTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
