<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendOrderItemToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendOrderItemToVehicle $parameters
     * @return \StructType\SendOrderItemToVehicleResponse|bool
     */
    public function sendOrderItemToVehicle(\StructType\SendOrderItemToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendOrderItemToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendOrderToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendOrderToVehicle $parameters
     * @return \StructType\SendOrderToVehicleResponse|bool
     */
    public function sendOrderToVehicle(\StructType\SendOrderToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendOrderToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendMessageToUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMessageToUser $parameters
     * @return \StructType\SendMessageToUserResponse|bool
     */
    public function sendMessageToUser(\StructType\SendMessageToUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendMessageToUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendMessageToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMessageToVehicle $parameters
     * @return \StructType\SendMessageToVehicleResponse|bool
     */
    public function sendMessageToVehicle(\StructType\SendMessageToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendMessageToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * sendMessageWithDestinationPointToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMessageWithDestinationPointToVehicle $parameters
     * @return \StructType\SendMessageWithDestinationPointToVehicleResponse|bool
     */
    public function sendMessageWithDestinationPointToVehicle(\StructType\SendMessageWithDestinationPointToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendMessageWithDestinationPointToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendFormMessageToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendFormMessageToVehicle $parameters
     * @return \StructType\SendFormMessageToVehicleResponse|bool
     */
    public function sendFormMessageToVehicle(\StructType\SendFormMessageToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendFormMessageToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * sendFormMessageWithDestinationPointToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendFormMessageWithDestinationPointToVehicle $parameters
     * @return \StructType\SendFormMessageWithDestinationPointToVehicleResponse|bool
     */
    public function sendFormMessageWithDestinationPointToVehicle(\StructType\SendFormMessageWithDestinationPointToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendFormMessageWithDestinationPointToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendFormMessageToVehicleResponse|\StructType\SendFormMessageWithDestinationPointToVehicleResponse|\StructType\SendMessageToUserResponse|\StructType\SendMessageToVehicleResponse|\StructType\SendMessageWithDestinationPointToVehicleResponse|\StructType\SendOrderItemToVehicleResponse|\StructType\SendOrderToVehicleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
