<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getDeletedServicePlans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedServicePlans $parameters
     * @return \StructType\GetDeletedServicePlansResponse|bool
     */
    public function getDeletedServicePlans(\StructType\GetDeletedServicePlans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedServicePlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedServicePlans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedServicePlans $parameters
     * @return \StructType\GetModifiedServicePlansResponse|bool
     */
    public function getModifiedServicePlans(\StructType\GetModifiedServicePlans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedServicePlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServicePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePlan $parameters
     * @return \StructType\GetServicePlanResponse|bool
     */
    public function getServicePlan(\StructType\GetServicePlan $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getServicePlan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCompletedOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompletedOrders $parameters
     * @return \StructType\GetCompletedOrdersResponse|bool
     */
    public function getCompletedOrders(\StructType\GetCompletedOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCompletedOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCoveredDistanceFromStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCoveredDistanceFromStatus $parameters
     * @return \StructType\GetCoveredDistanceFromStatusResponse|bool
     */
    public function getCoveredDistanceFromStatus(\StructType\GetCoveredDistanceFromStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCoveredDistanceFromStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCreatedOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCreatedOrders $parameters
     * @return \StructType\GetCreatedOrdersResponse|bool
     */
    public function getCreatedOrders(\StructType\GetCreatedOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCreatedOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomerOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerOrder $parameters
     * @return \StructType\GetCustomerOrderResponse|bool
     */
    public function getCustomerOrder(\StructType\GetCustomerOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomerOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomerOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerOrders $parameters
     * @return \StructType\GetCustomerOrdersResponse|bool
     */
    public function getCustomerOrders(\StructType\GetCustomerOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomerOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedOrders $parameters
     * @return \StructType\GetDeletedOrdersResponse|bool
     */
    public function getDeletedOrders(\StructType\GetDeletedOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElapsedTimeFromStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetElapsedTimeFromStatus $parameters
     * @return \StructType\GetElapsedTimeFromStatusResponse|bool
     */
    public function getElapsedTimeFromStatus(\StructType\GetElapsedTimeFromStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getElapsedTimeFromStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFuelConsumptionFromStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFuelConsumptionFromStatus $parameters
     * @return \StructType\GetFuelConsumptionFromStatusResponse|bool
     */
    public function getFuelConsumptionFromStatus(\StructType\GetFuelConsumptionFromStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFuelConsumptionFromStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMinimumOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMinimumOrder $parameters
     * @return \StructType\GetMinimumOrderResponse|bool
     */
    public function getMinimumOrder(\StructType\GetMinimumOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getMinimumOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedOrderItems $parameters
     * @return \StructType\GetModifiedOrderItemsResponse|bool
     */
    public function getModifiedOrderItems(\StructType\GetModifiedOrderItems $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedOrderItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrder $parameters
     * @return \StructType\GetOrderResponse|bool
     */
    public function getOrder(\StructType\GetOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderItem $parameters
     * @return \StructType\GetOrderItemResponse|bool
     */
    public function getOrderItem(\StructType\GetOrderItem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrdersMarkedAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrdersMarkedAsRead $parameters
     * @return \StructType\GetOrdersMarkedAsReadResponse|bool
     */
    public function getOrdersMarkedAsRead(\StructType\GetOrdersMarkedAsRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrdersMarkedAsRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomer $parameters
     * @return \StructType\GetCustomerResponse|bool
     */
    public function getCustomer(\StructType\GetCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomers $parameters
     * @return \StructType\GetCustomersResponse|bool
     */
    public function getCustomers(\StructType\GetCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedCustomers $parameters
     * @return \StructType\GetDeletedCustomersResponse|bool
     */
    public function getDeletedCustomers(\StructType\GetDeletedCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedCustomers $parameters
     * @return \StructType\GetModifiedCustomersResponse|bool
     */
    public function getModifiedCustomers(\StructType\GetModifiedCustomers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAlarms $parameters
     * @return \StructType\GetAlarmsResponse|bool
     */
    public function getAlarms(\StructType\GetAlarms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedAlarms $parameters
     * @return \StructType\GetDeletedAlarmsResponse|bool
     */
    public function getDeletedAlarms(\StructType\GetDeletedAlarms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedMessages $parameters
     * @return \StructType\GetDeletedMessagesResponse|bool
     */
    public function getDeletedMessages(\StructType\GetDeletedMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessageReadAckInfos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessageReadAckInfos $parameters
     * @return \StructType\GetMessageReadAckInfosResponse|bool
     */
    public function getMessageReadAckInfos(\StructType\GetMessageReadAckInfos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getMessageReadAckInfos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessagesInInbox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessagesInInbox $parameters
     * @return \StructType\GetMessagesInInboxResponse|bool
     */
    public function getMessagesInInbox(\StructType\GetMessagesInInbox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getMessagesInInbox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleEventMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleEventMessages $parameters
     * @return \StructType\GetVehicleEventMessagesResponse|bool
     */
    public function getVehicleEventMessages(\StructType\GetVehicleEventMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleEventMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewAlarms $parameters
     * @return \StructType\GetNewAlarmsResponse|bool
     */
    public function getNewAlarms(\StructType\GetNewAlarms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewMessages $parameters
     * @return \StructType\GetNewMessagesResponse|bool
     */
    public function getNewMessages(\StructType\GetNewMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewVehicleEventMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewVehicleEventMessages $parameters
     * @return \StructType\GetNewVehicleEventMessagesResponse|bool
     */
    public function getNewVehicleEventMessages(\StructType\GetNewVehicleEventMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewVehicleEventMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewMessagesSendstatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewMessagesSendstatus $parameters
     * @return \StructType\GetNewMessagesSendstatusResponse|bool
     */
    public function getNewMessagesSendstatus(\StructType\GetNewMessagesSendstatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewMessagesSendstatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDriverReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverReportData $parameters
     * @return \StructType\GetDriverReportDataResponse|bool
     */
    public function getDriverReportData(\StructType\GetDriverReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDriverReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDtjReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDtjReportData $parameters
     * @return \StructType\GetDtjReportDataResponse|bool
     */
    public function getDtjReportData(\StructType\GetDtjReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDtjReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewDriverReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewDriverReportData $parameters
     * @return \StructType\GetNewDriverReportDataResponse|bool
     */
    public function getNewDriverReportData(\StructType\GetNewDriverReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewDriverReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewDtjReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewDtjReportData $parameters
     * @return \StructType\GetNewDtjReportDataResponse|bool
     */
    public function getNewDtjReportData(\StructType\GetNewDtjReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewDtjReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewVehicleReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewVehicleReportData $parameters
     * @return \StructType\GetNewVehicleReportDataResponse|bool
     */
    public function getNewVehicleReportData(\StructType\GetNewVehicleReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewVehicleReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewVehicleReportDataExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewVehicleReportDataExtended $parameters
     * @return \StructType\GetNewVehicleReportDataExtendedResponse|bool
     */
    public function getNewVehicleReportDataExtended(\StructType\GetNewVehicleReportDataExtended $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewVehicleReportDataExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleReportData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleReportData $parameters
     * @return \StructType\GetVehicleReportDataResponse|bool
     */
    public function getVehicleReportData(\StructType\GetVehicleReportData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleReportData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicleReportDataExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleReportDataExtended $parameters
     * @return \StructType\GetVehicleReportDataExtendedResponse|bool
     */
    public function getVehicleReportDataExtended(\StructType\GetVehicleReportDataExtended $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicleReportDataExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedPois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedPois $parameters
     * @return \StructType\GetDeletedPoisResponse|bool
     */
    public function getDeletedPois(\StructType\GetDeletedPois $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedPois($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedPois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedPois $parameters
     * @return \StructType\GetModifiedPoisResponse|bool
     */
    public function getModifiedPois(\StructType\GetModifiedPois $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedPois($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoi $parameters
     * @return \StructType\GetPoiResponse|bool
     */
    public function getPoi(\StructType\GetPoi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPoi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPois $parameters
     * @return \StructType\GetPoisResponse|bool
     */
    public function getPois(\StructType\GetPois $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPois($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoisByBoundingBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoisByBoundingBox $parameters
     * @return \StructType\GetPoisByBoundingBoxResponse|bool
     */
    public function getPoisByBoundingBox(\StructType\GetPoisByBoundingBox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPoisByBoundingBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoisByType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoisByType $parameters
     * @return \StructType\GetPoisByTypeResponse|bool
     */
    public function getPoisByType(\StructType\GetPoisByType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPoisByType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoisByTypeAndBoundingBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoisByTypeAndBoundingBox $parameters
     * @return \StructType\GetPoisByTypeAndBoundingBoxResponse|bool
     */
    public function getPoisByTypeAndBoundingBox(\StructType\GetPoisByTypeAndBoundingBox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPoisByTypeAndBoundingBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedDrivers $parameters
     * @return \StructType\GetDeletedDriversResponse|bool
     */
    public function getDeletedDrivers(\StructType\GetDeletedDrivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedUsers $parameters
     * @return \StructType\GetDeletedUsersResponse|bool
     */
    public function getDeletedUsers(\StructType\GetDeletedUsers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedVehicles $parameters
     * @return \StructType\GetDeletedVehiclesResponse|bool
     */
    public function getDeletedVehicles(\StructType\GetDeletedVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDriver
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriver $parameters
     * @return \StructType\GetDriverResponse|bool
     */
    public function getDriver(\StructType\GetDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDriverV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverV2 $parameters
     * @return \StructType\GetDriverV2Response|bool
     */
    public function getDriverV2(\StructType\GetDriverV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDriverV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDrivers $parameters
     * @return \StructType\GetDriversResponse|bool
     */
    public function getDrivers(\StructType\GetDrivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDriversV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriversV2 $parameters
     * @return \StructType\GetDriversV2Response|bool
     */
    public function getDriversV2(\StructType\GetDriversV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDriversV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDriverTimes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverTimes $parameters
     * @return \StructType\GetDriverTimesResponse|bool
     */
    public function getDriverTimes(\StructType\GetDriverTimes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDriverTimes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFleetInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFleetInfo $parameters
     * @return \StructType\GetFleetInfoResponse|bool
     */
    public function getFleetInfo(\StructType\GetFleetInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFleetInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedDrivers $parameters
     * @return \StructType\GetModifiedDriversResponse|bool
     */
    public function getModifiedDrivers(\StructType\GetModifiedDrivers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedUsers $parameters
     * @return \StructType\GetModifiedUsersResponse|bool
     */
    public function getModifiedUsers(\StructType\GetModifiedUsers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedVehicles $parameters
     * @return \StructType\GetModifiedVehiclesResponse|bool
     */
    public function getModifiedVehicles(\StructType\GetModifiedVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUsers $parameters
     * @return \StructType\GetUsersResponse|bool
     */
    public function getUsers(\StructType\GetUsers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUsersAssignedToVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUsersAssignedToVehicle $parameters
     * @return \StructType\GetUsersAssignedToVehicleResponse|bool
     */
    public function getUsersAssignedToVehicle(\StructType\GetUsersAssignedToVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUsersAssignedToVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicle $parameters
     * @return \StructType\GetVehicleResponse|bool
     */
    public function getVehicle(\StructType\GetVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicles $parameters
     * @return \StructType\GetVehiclesResponse|bool
     */
    public function getVehicles(\StructType\GetVehicles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehiclesV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehiclesV2 $parameters
     * @return \StructType\GetVehiclesV2Response|bool
     */
    public function getVehiclesV2(\StructType\GetVehiclesV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehiclesV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getForm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetForm $parameters
     * @return \StructType\GetFormResponse|bool
     */
    public function getForm(\StructType\GetForm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getForm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getForms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetForms $parameters
     * @return \StructType\GetFormsResponse|bool
     */
    public function getForms(\StructType\GetForms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getForms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormsInVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormsInVehicle $parameters
     * @return \StructType\GetFormsInVehicleResponse|bool
     */
    public function getFormsInVehicle(\StructType\GetFormsInVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFormsInVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewPositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewPositions $parameters
     * @return \StructType\GetNewPositionsResponse|bool
     */
    public function getNewPositions(\StructType\GetNewPositions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewPositions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewTrackingData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewTrackingData $parameters
     * @return \StructType\GetNewTrackingDataResponse|bool
     */
    public function getNewTrackingData(\StructType\GetNewTrackingData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewTrackingData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewTrackingDataV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewTrackingDataV2 $parameters
     * @return \StructType\GetNewTrackingDataV2Response|bool
     */
    public function getNewTrackingDataV2(\StructType\GetNewTrackingDataV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewTrackingDataV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewTrackingDataWithETAInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewTrackingDataWithETAInfo $parameters
     * @return \StructType\GetNewTrackingDataWithETAInfoResponse|bool
     */
    public function getNewTrackingDataWithETAInfo(\StructType\GetNewTrackingDataWithETAInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewTrackingDataWithETAInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVehiclePositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehiclePositions $parameters
     * @return \StructType\GetVehiclePositionsResponse|bool
     */
    public function getVehiclePositions(\StructType\GetVehiclePositions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVehiclePositions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLastKnownPositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastKnownPositions $parameters
     * @return \StructType\GetLastKnownPositionsResponse|bool
     */
    public function getLastKnownPositions(\StructType\GetLastKnownPositions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getLastKnownPositions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDTMAlarmSetting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDTMAlarmSetting $parameters
     * @return \StructType\GetDTMAlarmSettingResponse|bool
     */
    public function getDTMAlarmSetting(\StructType\GetDTMAlarmSetting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDTMAlarmSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDTMAlarmsForVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDTMAlarmsForVehicle $parameters
     * @return \StructType\GetDTMAlarmsForVehicleResponse|bool
     */
    public function getDTMAlarmsForVehicle(\StructType\GetDTMAlarmsForVehicle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDTMAlarmsForVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedDTMAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedDTMAlarms $parameters
     * @return \StructType\GetDeletedDTMAlarmsResponse|bool
     */
    public function getDeletedDTMAlarms(\StructType\GetDeletedDTMAlarms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedDTMAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewDTMAlarmSetupSendStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewDTMAlarmSetupSendStatuses $parameters
     * @return \StructType\GetNewDTMAlarmSetupSendStatusesResponse|bool
     */
    public function getNewDTMAlarmSetupSendStatuses(\StructType\GetNewDTMAlarmSetupSendStatuses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewDTMAlarmSetupSendStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewDTMAlarms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewDTMAlarms $parameters
     * @return \StructType\GetNewDTMAlarmsResponse|bool
     */
    public function getNewDTMAlarms(\StructType\GetNewDTMAlarms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewDTMAlarms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedFormMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedFormMessages $parameters
     * @return \StructType\GetDeletedFormMessagesResponse|bool
     */
    public function getDeletedFormMessages(\StructType\GetDeletedFormMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedFormMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormMessageReadAckInfos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormMessageReadAckInfos $parameters
     * @return \StructType\GetFormMessageReadAckInfosResponse|bool
     */
    public function getFormMessageReadAckInfos(\StructType\GetFormMessageReadAckInfos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFormMessageReadAckInfos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormMessagesByForm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormMessagesByForm $parameters
     * @return \StructType\GetFormMessagesByFormResponse|bool
     */
    public function getFormMessagesByForm(\StructType\GetFormMessagesByForm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFormMessagesByForm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormMessagesInInbox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormMessagesInInbox $parameters
     * @return \StructType\GetFormMessagesInInboxResponse|bool
     */
    public function getFormMessagesInInbox(\StructType\GetFormMessagesInInbox $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFormMessagesInInbox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewFormMessageSendstatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewFormMessageSendstatus $parameters
     * @return \StructType\GetNewFormMessageSendstatusResponse|bool
     */
    public function getNewFormMessageSendstatus(\StructType\GetNewFormMessageSendstatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewFormMessageSendstatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewFormMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewFormMessages $parameters
     * @return \StructType\GetNewFormMessagesResponse|bool
     */
    public function getNewFormMessages(\StructType\GetNewFormMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewFormMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeofenceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeofenceData $parameters
     * @return \StructType\GetGeofenceDataResponse|bool
     */
    public function getGeofenceData(\StructType\GetGeofenceData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeofenceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewGeofenceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewGeofenceData $parameters
     * @return \StructType\GetNewGeofenceDataResponse|bool
     */
    public function getNewGeofenceData(\StructType\GetNewGeofenceData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewGeofenceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedGeofencePlus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedGeofencePlus $parameters
     * @return \StructType\GetDeletedGeofencePlusResponse|bool
     */
    public function getDeletedGeofencePlus(\StructType\GetDeletedGeofencePlus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeletedGeofencePlus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeofencePlus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeofencePlus $parameters
     * @return \StructType\GetGeofencePlusResponse|bool
     */
    public function getGeofencePlus(\StructType\GetGeofencePlus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeofencePlus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeofences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeofences $parameters
     * @return \StructType\GetGeofencesResponse|bool
     */
    public function getGeofences(\StructType\GetGeofences $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getGeofences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModifiedGeofencePlus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifiedGeofencePlus $parameters
     * @return \StructType\GetModifiedGeofencePlusResponse|bool
     */
    public function getModifiedGeofencePlus(\StructType\GetModifiedGeofencePlus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModifiedGeofencePlus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewGeofencePlusData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewGeofencePlusData $parameters
     * @return \StructType\GetNewGeofencePlusDataResponse|bool
     */
    public function getNewGeofencePlusData(\StructType\GetNewGeofencePlusData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getNewGeofencePlusData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAlarmsResponse|\StructType\GetCompletedOrdersResponse|\StructType\GetCoveredDistanceFromStatusResponse|\StructType\GetCreatedOrdersResponse|\StructType\GetCustomerOrderResponse|\StructType\GetCustomerOrdersResponse|\StructType\GetCustomerResponse|\StructType\GetCustomersResponse|\StructType\GetDeletedAlarmsResponse|\StructType\GetDeletedCustomersResponse|\StructType\GetDeletedDriversResponse|\StructType\GetDeletedDTMAlarmsResponse|\StructType\GetDeletedFormMessagesResponse|\StructType\GetDeletedGeofencePlusResponse|\StructType\GetDeletedMessagesResponse|\StructType\GetDeletedOrdersResponse|\StructType\GetDeletedPoisResponse|\StructType\GetDeletedServicePlansResponse|\StructType\GetDeletedUsersResponse|\StructType\GetDeletedVehiclesResponse|\StructType\GetDriverReportDataResponse|\StructType\GetDriverResponse|\StructType\GetDriversResponse|\StructType\GetDriversV2Response|\StructType\GetDriverTimesResponse|\StructType\GetDriverV2Response|\StructType\GetDtjReportDataResponse|\StructType\GetDTMAlarmSettingResponse|\StructType\GetDTMAlarmsForVehicleResponse|\StructType\GetElapsedTimeFromStatusResponse|\StructType\GetFleetInfoResponse|\StructType\GetFormMessageReadAckInfosResponse|\StructType\GetFormMessagesByFormResponse|\StructType\GetFormMessagesInInboxResponse|\StructType\GetFormResponse|\StructType\GetFormsInVehicleResponse|\StructType\GetFormsResponse|\StructType\GetFuelConsumptionFromStatusResponse|\StructType\GetGeofenceDataResponse|\StructType\GetGeofencePlusResponse|\StructType\GetGeofencesResponse|\StructType\GetLastKnownPositionsResponse|\StructType\GetMessageReadAckInfosResponse|\StructType\GetMessagesInInboxResponse|\StructType\GetMinimumOrderResponse|\StructType\GetModifiedCustomersResponse|\StructType\GetModifiedDriversResponse|\StructType\GetModifiedGeofencePlusResponse|\StructType\GetModifiedOrderItemsResponse|\StructType\GetModifiedPoisResponse|\StructType\GetModifiedServicePlansResponse|\StructType\GetModifiedUsersResponse|\StructType\GetModifiedVehiclesResponse|\StructType\GetNewAlarmsResponse|\StructType\GetNewDriverReportDataResponse|\StructType\GetNewDtjReportDataResponse|\StructType\GetNewDTMAlarmSetupSendStatusesResponse|\StructType\GetNewDTMAlarmsResponse|\StructType\GetNewFormMessageSendstatusResponse|\StructType\GetNewFormMessagesResponse|\StructType\GetNewGeofenceDataResponse|\StructType\GetNewGeofencePlusDataResponse|\StructType\GetNewMessagesResponse|\StructType\GetNewMessagesSendstatusResponse|\StructType\GetNewPositionsResponse|\StructType\GetNewTrackingDataResponse|\StructType\GetNewTrackingDataV2Response|\StructType\GetNewTrackingDataWithETAInfoResponse|\StructType\GetNewVehicleEventMessagesResponse|\StructType\GetNewVehicleReportDataExtendedResponse|\StructType\GetNewVehicleReportDataResponse|\StructType\GetOrderItemResponse|\StructType\GetOrderResponse|\StructType\GetOrdersMarkedAsReadResponse|\StructType\GetPoiResponse|\StructType\GetPoisByBoundingBoxResponse|\StructType\GetPoisByTypeAndBoundingBoxResponse|\StructType\GetPoisByTypeResponse|\StructType\GetPoisResponse|\StructType\GetServicePlanResponse|\StructType\GetUsersAssignedToVehicleResponse|\StructType\GetUsersResponse|\StructType\GetVehicleEventMessagesResponse|\StructType\GetVehiclePositionsResponse|\StructType\GetVehicleReportDataExtendedResponse|\StructType\GetVehicleReportDataResponse|\StructType\GetVehicleResponse|\StructType\GetVehiclesResponse|\StructType\GetVehiclesV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
