<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkNotificationFlags
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckNotificationFlags $parameters
     * @return \StructType\CheckNotificationFlagsResponse|bool
     */
    public function checkNotificationFlags(\StructType\CheckNotificationFlags $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkNotificationFlags($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkNotificationFlags2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckNotificationFlags2 $parameters
     * @return \StructType\CheckNotificationFlags2Response|bool
     */
    public function checkNotificationFlags2(\StructType\CheckNotificationFlags2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkNotificationFlags2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkNotificationFlags3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckNotificationFlags3 $parameters
     * @return \StructType\CheckNotificationFlags3Response|bool
     */
    public function checkNotificationFlags3(\StructType\CheckNotificationFlags3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkNotificationFlags3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckNotificationFlags2Response|\StructType\CheckNotificationFlags3Response|\StructType\CheckNotificationFlagsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
