<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_UserArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_UserArrayTO extends AbstractStructArrayBase
{
    /**
     * The users
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_UserTO[]
     */
    public $users;
    /**
     * Constructor method for Api_UserArrayTO
     * @uses Api_UserArrayTO::setUsers()
     * @param \StructType\Api_UserTO[] $users
     */
    public function __construct(array $users = array())
    {
        $this
            ->setUsers($users);
    }
    /**
     * Get users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_UserTO[]|null
     */
    public function getUsers()
    {
        return isset($this->users) ? $this->users : null;
    }
    /**
     * Set users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_UserTO[] $users
     * @return \ArrayType\Api_UserArrayTO
     */
    public function setUsers(array $users = array())
    {
        foreach ($users as $api_UserArrayTOUsersItem) {
            // validation for constraint: itemType
            if (!$api_UserArrayTOUsersItem instanceof \StructType\Api_UserTO) {
                throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\Api_UserTO, "%s" given', is_object($api_UserArrayTOUsersItem) ? get_class($api_UserArrayTOUsersItem) : gettype($api_UserArrayTOUsersItem)), __LINE__);
            }
        }
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->users);
        } else {
            $this->users = $users;
        }
        return $this;
    }
    /**
     * Add item to users value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_UserTO $item
     * @return \ArrayType\Api_UserArrayTO
     */
    public function addToUsers(\StructType\Api_UserTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_UserTO) {
            throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\Api_UserTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->users[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_UserTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_UserTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_UserTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_UserTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_UserTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string users
     */
    public function getAttributeName()
    {
        return 'users';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_UserArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
