<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_DriverInfoArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_DriverInfoArrayTO extends AbstractStructArrayBase
{
    /**
     * The driverInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_DriverInfoTO[]
     */
    public $driverInfos;
    /**
     * Constructor method for Api_DriverInfoArrayTO
     * @uses Api_DriverInfoArrayTO::setDriverInfos()
     * @param \StructType\Api_DriverInfoTO[] $driverInfos
     */
    public function __construct(array $driverInfos = array())
    {
        $this
            ->setDriverInfos($driverInfos);
    }
    /**
     * Get driverInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_DriverInfoTO[]|null
     */
    public function getDriverInfos()
    {
        return isset($this->driverInfos) ? $this->driverInfos : null;
    }
    /**
     * Set driverInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverInfoTO[] $driverInfos
     * @return \ArrayType\Api_DriverInfoArrayTO
     */
    public function setDriverInfos(array $driverInfos = array())
    {
        foreach ($driverInfos as $api_DriverInfoArrayTODriverInfosItem) {
            // validation for constraint: itemType
            if (!$api_DriverInfoArrayTODriverInfosItem instanceof \StructType\Api_DriverInfoTO) {
                throw new \InvalidArgumentException(sprintf('The driverInfos property can only contain items of \StructType\Api_DriverInfoTO, "%s" given', is_object($api_DriverInfoArrayTODriverInfosItem) ? get_class($api_DriverInfoArrayTODriverInfosItem) : gettype($api_DriverInfoArrayTODriverInfosItem)), __LINE__);
            }
        }
        if (is_null($driverInfos) || (is_array($driverInfos) && empty($driverInfos))) {
            unset($this->driverInfos);
        } else {
            $this->driverInfos = $driverInfos;
        }
        return $this;
    }
    /**
     * Add item to driverInfos value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverInfoTO $item
     * @return \ArrayType\Api_DriverInfoArrayTO
     */
    public function addToDriverInfos(\StructType\Api_DriverInfoTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_DriverInfoTO) {
            throw new \InvalidArgumentException(sprintf('The driverInfos property can only contain items of \StructType\Api_DriverInfoTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driverInfos[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_DriverInfoTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_DriverInfoTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_DriverInfoTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_DriverInfoTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_DriverInfoTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string driverInfos
     */
    public function getAttributeName()
    {
        return 'driverInfos';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_DriverInfoArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
