<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCreatedOrdersResponse StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getCreatedOrdersResponse
 * @subpackage Structs
 */
class GetCreatedOrdersResponse extends AbstractStructBase
{
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $result;
    /**
     * Constructor method for getCreatedOrdersResponse
     * @uses GetCreatedOrdersResponse::setResult()
     * @param string[] $result
     */
    public function __construct(array $result = array())
    {
        $this
            ->setResult($result);
    }
    /**
     * Get result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getResult()
    {
        return isset($this->result) ? $this->result : null;
    }
    /**
     * Set result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $result
     * @return \StructType\GetCreatedOrdersResponse
     */
    public function setResult(array $result = array())
    {
        foreach ($result as $getCreatedOrdersResponseResultItem) {
            // validation for constraint: itemType
            if (!is_string($getCreatedOrdersResponseResultItem)) {
                throw new \InvalidArgumentException(sprintf('The result property can only contain items of string, "%s" given', is_object($getCreatedOrdersResponseResultItem) ? get_class($getCreatedOrdersResponseResultItem) : gettype($getCreatedOrdersResponseResultItem)), __LINE__);
            }
        }
        if (is_null($result) || (is_array($result) && empty($result))) {
            unset($this->result);
        } else {
            $this->result = $result;
        }
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetCreatedOrdersResponse
     */
    public function addToResult($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The result property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->result[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCreatedOrdersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
