<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_UserTO StructType
 * @subpackage Structs
 */
class Api_UserTO extends AbstractStructBase
{
    /**
     * The assignedDrivers
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\Api_LongArrayTO
     */
    public $assignedDrivers;
    /**
     * The assignedVehicles
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\Api_LongArrayTO
     */
    public $assignedVehicles;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The emailAlias
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emailAlias;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firstName;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_UserId
     */
    public $id;
    /**
     * The isDeleted
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $isDeleted;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastName;
    /**
     * The loginname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $loginname;
    /**
     * The measureType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $measureType;
    /**
     * The showCommunicationCostWarning
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $showCommunicationCostWarning;
    /**
     * The userRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $userRoles;
    /**
     * Constructor method for Api_UserTO
     * @uses Api_UserTO::setAssignedDrivers()
     * @uses Api_UserTO::setAssignedVehicles()
     * @uses Api_UserTO::setDescription()
     * @uses Api_UserTO::setEmail()
     * @uses Api_UserTO::setEmailAlias()
     * @uses Api_UserTO::setFirstName()
     * @uses Api_UserTO::setId()
     * @uses Api_UserTO::setIsDeleted()
     * @uses Api_UserTO::setLanguage()
     * @uses Api_UserTO::setLastName()
     * @uses Api_UserTO::setLoginname()
     * @uses Api_UserTO::setMeasureType()
     * @uses Api_UserTO::setShowCommunicationCostWarning()
     * @uses Api_UserTO::setUserRoles()
     * @param \ArrayType\Api_LongArrayTO $assignedDrivers
     * @param \ArrayType\Api_LongArrayTO $assignedVehicles
     * @param string $description
     * @param string $email
     * @param string $emailAlias
     * @param string $firstName
     * @param \StructType\Api_UserId $id
     * @param \StructType\Api_Boolean $isDeleted
     * @param string $language
     * @param string $lastName
     * @param string $loginname
     * @param string $measureType
     * @param \StructType\Api_Boolean $showCommunicationCostWarning
     * @param string[] $userRoles
     */
    public function __construct(\ArrayType\Api_LongArrayTO $assignedDrivers = null, \ArrayType\Api_LongArrayTO $assignedVehicles = null, $description = null, $email = null, $emailAlias = null, $firstName = null, \StructType\Api_UserId $id = null, \StructType\Api_Boolean $isDeleted = null, $language = null, $lastName = null, $loginname = null, $measureType = null, \StructType\Api_Boolean $showCommunicationCostWarning = null, array $userRoles = array())
    {
        $this
            ->setAssignedDrivers($assignedDrivers)
            ->setAssignedVehicles($assignedVehicles)
            ->setDescription($description)
            ->setEmail($email)
            ->setEmailAlias($emailAlias)
            ->setFirstName($firstName)
            ->setId($id)
            ->setIsDeleted($isDeleted)
            ->setLanguage($language)
            ->setLastName($lastName)
            ->setLoginname($loginname)
            ->setMeasureType($measureType)
            ->setShowCommunicationCostWarning($showCommunicationCostWarning)
            ->setUserRoles($userRoles);
    }
    /**
     * Get assignedDrivers value
     * @return \ArrayType\Api_LongArrayTO|null
     */
    public function getAssignedDrivers()
    {
        return $this->assignedDrivers;
    }
    /**
     * Set assignedDrivers value
     * @param \ArrayType\Api_LongArrayTO $assignedDrivers
     * @return \StructType\Api_UserTO
     */
    public function setAssignedDrivers(\ArrayType\Api_LongArrayTO $assignedDrivers = null)
    {
        $this->assignedDrivers = $assignedDrivers;
        return $this;
    }
    /**
     * Get assignedVehicles value
     * @return \ArrayType\Api_LongArrayTO|null
     */
    public function getAssignedVehicles()
    {
        return $this->assignedVehicles;
    }
    /**
     * Set assignedVehicles value
     * @param \ArrayType\Api_LongArrayTO $assignedVehicles
     * @return \StructType\Api_UserTO
     */
    public function setAssignedVehicles(\ArrayType\Api_LongArrayTO $assignedVehicles = null)
    {
        $this->assignedVehicles = $assignedVehicles;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Api_UserTO
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Api_UserTO
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get emailAlias value
     * @return string|null
     */
    public function getEmailAlias()
    {
        return $this->emailAlias;
    }
    /**
     * Set emailAlias value
     * @param string $emailAlias
     * @return \StructType\Api_UserTO
     */
    public function setEmailAlias($emailAlias = null)
    {
        // validation for constraint: string
        if (!is_null($emailAlias) && !is_string($emailAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAlias)), __LINE__);
        }
        $this->emailAlias = $emailAlias;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Api_UserTO
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Api_UserId|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Api_UserId $id
     * @return \StructType\Api_UserTO
     */
    public function setId(\StructType\Api_UserId $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get isDeleted value
     * @return \StructType\Api_Boolean|null
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }
    /**
     * Set isDeleted value
     * @param \StructType\Api_Boolean $isDeleted
     * @return \StructType\Api_UserTO
     */
    public function setIsDeleted(\StructType\Api_Boolean $isDeleted = null)
    {
        $this->isDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Api_UserTO
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Api_UserTO
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get loginname value
     * @return string|null
     */
    public function getLoginname()
    {
        return $this->loginname;
    }
    /**
     * Set loginname value
     * @param string $loginname
     * @return \StructType\Api_UserTO
     */
    public function setLoginname($loginname = null)
    {
        // validation for constraint: string
        if (!is_null($loginname) && !is_string($loginname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginname)), __LINE__);
        }
        $this->loginname = $loginname;
        return $this;
    }
    /**
     * Get measureType value
     * @return string|null
     */
    public function getMeasureType()
    {
        return $this->measureType;
    }
    /**
     * Set measureType value
     * @param string $measureType
     * @return \StructType\Api_UserTO
     */
    public function setMeasureType($measureType = null)
    {
        // validation for constraint: string
        if (!is_null($measureType) && !is_string($measureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measureType)), __LINE__);
        }
        $this->measureType = $measureType;
        return $this;
    }
    /**
     * Get showCommunicationCostWarning value
     * @return \StructType\Api_Boolean|null
     */
    public function getShowCommunicationCostWarning()
    {
        return $this->showCommunicationCostWarning;
    }
    /**
     * Set showCommunicationCostWarning value
     * @param \StructType\Api_Boolean $showCommunicationCostWarning
     * @return \StructType\Api_UserTO
     */
    public function setShowCommunicationCostWarning(\StructType\Api_Boolean $showCommunicationCostWarning = null)
    {
        $this->showCommunicationCostWarning = $showCommunicationCostWarning;
        return $this;
    }
    /**
     * Get userRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getUserRoles()
    {
        return isset($this->userRoles) ? $this->userRoles : null;
    }
    /**
     * Set userRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $userRoles
     * @return \StructType\Api_UserTO
     */
    public function setUserRoles(array $userRoles = array())
    {
        foreach ($userRoles as $api_UserTOUserRolesItem) {
            // validation for constraint: itemType
            if (!is_string($api_UserTOUserRolesItem)) {
                throw new \InvalidArgumentException(sprintf('The userRoles property can only contain items of string, "%s" given', is_object($api_UserTOUserRolesItem) ? get_class($api_UserTOUserRolesItem) : gettype($api_UserTOUserRolesItem)), __LINE__);
            }
        }
        if (is_null($userRoles) || (is_array($userRoles) && empty($userRoles))) {
            unset($this->userRoles);
        } else {
            $this->userRoles = $userRoles;
        }
        return $this;
    }
    /**
     * Add item to userRoles value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Api_UserTO
     */
    public function addToUserRoles($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The userRoles property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->userRoles[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_UserTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
