<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderItemTO StructType
 * @subpackage Structs
 */
class Api_OrderItemTO extends AbstractStructBase
{
    /**
     * The activityType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $activityType;
    /**
     * The completionTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $completionTime;
    /**
     * The createTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $createTime;
    /**
     * The deletedTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $deletedTime;
    /**
     * The lastModifyTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $lastModifyTime;
    /**
     * The lastSendStatusTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $lastSendStatusTime;
    /**
     * The orderFormFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\Api_OrderFormFieldTO[]
     */
    public $orderFormFields;
    /**
     * The orderItemNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $orderItemNumber;
    /**
     * The orderItemStatusList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_OrderStatusTO[]
     */
    public $orderItemStatusList;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The plannedFrom
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Date
     */
    public $plannedFrom;
    /**
     * The plannedTo
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Date
     */
    public $plannedTo;
    /**
     * The poiId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_PoiId
     */
    public $poiId;
    /**
     * The sendStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sendStatus;
    /**
     * The templateId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Long
     */
    public $templateId;
    /**
     * Constructor method for Api_OrderItemTO
     * @uses Api_OrderItemTO::setActivityType()
     * @uses Api_OrderItemTO::setCompletionTime()
     * @uses Api_OrderItemTO::setCreateTime()
     * @uses Api_OrderItemTO::setDeletedTime()
     * @uses Api_OrderItemTO::setLastModifyTime()
     * @uses Api_OrderItemTO::setLastSendStatusTime()
     * @uses Api_OrderItemTO::setOrderFormFields()
     * @uses Api_OrderItemTO::setOrderItemNumber()
     * @uses Api_OrderItemTO::setOrderItemStatusList()
     * @uses Api_OrderItemTO::setOrderNumber()
     * @uses Api_OrderItemTO::setPlannedFrom()
     * @uses Api_OrderItemTO::setPlannedTo()
     * @uses Api_OrderItemTO::setPoiId()
     * @uses Api_OrderItemTO::setSendStatus()
     * @uses Api_OrderItemTO::setTemplateId()
     * @param string $activityType
     * @param \StructType\Api_Date $completionTime
     * @param \StructType\Api_Date $createTime
     * @param \StructType\Api_Date $deletedTime
     * @param \StructType\Api_Date $lastModifyTime
     * @param \StructType\Api_Date $lastSendStatusTime
     * @param \StructType\Api_OrderFormFieldTO[] $orderFormFields
     * @param \StructType\Api_Long $orderItemNumber
     * @param \StructType\Api_OrderStatusTO[] $orderItemStatusList
     * @param string $orderNumber
     * @param \StructType\Api_Date $plannedFrom
     * @param \StructType\Api_Date $plannedTo
     * @param \StructType\Api_PoiId $poiId
     * @param string $sendStatus
     * @param \StructType\Api_Long $templateId
     */
    public function __construct($activityType = null, \StructType\Api_Date $completionTime = null, \StructType\Api_Date $createTime = null, \StructType\Api_Date $deletedTime = null, \StructType\Api_Date $lastModifyTime = null, \StructType\Api_Date $lastSendStatusTime = null, array $orderFormFields = array(), \StructType\Api_Long $orderItemNumber = null, array $orderItemStatusList = array(), $orderNumber = null, \StructType\Api_Date $plannedFrom = null, \StructType\Api_Date $plannedTo = null, \StructType\Api_PoiId $poiId = null, $sendStatus = null, \StructType\Api_Long $templateId = null)
    {
        $this
            ->setActivityType($activityType)
            ->setCompletionTime($completionTime)
            ->setCreateTime($createTime)
            ->setDeletedTime($deletedTime)
            ->setLastModifyTime($lastModifyTime)
            ->setLastSendStatusTime($lastSendStatusTime)
            ->setOrderFormFields($orderFormFields)
            ->setOrderItemNumber($orderItemNumber)
            ->setOrderItemStatusList($orderItemStatusList)
            ->setOrderNumber($orderNumber)
            ->setPlannedFrom($plannedFrom)
            ->setPlannedTo($plannedTo)
            ->setPoiId($poiId)
            ->setSendStatus($sendStatus)
            ->setTemplateId($templateId);
    }
    /**
     * Get activityType value
     * @return string|null
     */
    public function getActivityType()
    {
        return $this->activityType;
    }
    /**
     * Set activityType value
     * @param string $activityType
     * @return \StructType\Api_OrderItemTO
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: string
        if (!is_null($activityType) && !is_string($activityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityType)), __LINE__);
        }
        $this->activityType = $activityType;
        return $this;
    }
    /**
     * Get completionTime value
     * @return \StructType\Api_Date|null
     */
    public function getCompletionTime()
    {
        return $this->completionTime;
    }
    /**
     * Set completionTime value
     * @param \StructType\Api_Date $completionTime
     * @return \StructType\Api_OrderItemTO
     */
    public function setCompletionTime(\StructType\Api_Date $completionTime = null)
    {
        $this->completionTime = $completionTime;
        return $this;
    }
    /**
     * Get createTime value
     * @return \StructType\Api_Date|null
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }
    /**
     * Set createTime value
     * @param \StructType\Api_Date $createTime
     * @return \StructType\Api_OrderItemTO
     */
    public function setCreateTime(\StructType\Api_Date $createTime = null)
    {
        $this->createTime = $createTime;
        return $this;
    }
    /**
     * Get deletedTime value
     * @return \StructType\Api_Date|null
     */
    public function getDeletedTime()
    {
        return $this->deletedTime;
    }
    /**
     * Set deletedTime value
     * @param \StructType\Api_Date $deletedTime
     * @return \StructType\Api_OrderItemTO
     */
    public function setDeletedTime(\StructType\Api_Date $deletedTime = null)
    {
        $this->deletedTime = $deletedTime;
        return $this;
    }
    /**
     * Get lastModifyTime value
     * @return \StructType\Api_Date|null
     */
    public function getLastModifyTime()
    {
        return $this->lastModifyTime;
    }
    /**
     * Set lastModifyTime value
     * @param \StructType\Api_Date $lastModifyTime
     * @return \StructType\Api_OrderItemTO
     */
    public function setLastModifyTime(\StructType\Api_Date $lastModifyTime = null)
    {
        $this->lastModifyTime = $lastModifyTime;
        return $this;
    }
    /**
     * Get lastSendStatusTime value
     * @return \StructType\Api_Date|null
     */
    public function getLastSendStatusTime()
    {
        return $this->lastSendStatusTime;
    }
    /**
     * Set lastSendStatusTime value
     * @param \StructType\Api_Date $lastSendStatusTime
     * @return \StructType\Api_OrderItemTO
     */
    public function setLastSendStatusTime(\StructType\Api_Date $lastSendStatusTime = null)
    {
        $this->lastSendStatusTime = $lastSendStatusTime;
        return $this;
    }
    /**
     * Get orderFormFields value
     * @return \StructType\Api_OrderFormFieldTO[]|null
     */
    public function getOrderFormFields()
    {
        return $this->orderFormFields;
    }
    /**
     * Set orderFormFields value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderFormFieldTO[] $orderFormFields
     * @return \StructType\Api_OrderItemTO
     */
    public function setOrderFormFields(array $orderFormFields = array())
    {
        foreach ($orderFormFields as $api_OrderItemTOOrderFormFieldsItem) {
            // validation for constraint: itemType
            if (!$api_OrderItemTOOrderFormFieldsItem instanceof \StructType\Api_OrderFormFieldTO) {
                throw new \InvalidArgumentException(sprintf('The orderFormFields property can only contain items of \StructType\Api_OrderFormFieldTO, "%s" given', is_object($api_OrderItemTOOrderFormFieldsItem) ? get_class($api_OrderItemTOOrderFormFieldsItem) : gettype($api_OrderItemTOOrderFormFieldsItem)), __LINE__);
            }
        }
        $this->orderFormFields = $orderFormFields;
        return $this;
    }
    /**
     * Add item to orderFormFields value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderFormFieldTO $item
     * @return \StructType\Api_OrderItemTO
     */
    public function addToOrderFormFields(\StructType\Api_OrderFormFieldTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_OrderFormFieldTO) {
            throw new \InvalidArgumentException(sprintf('The orderFormFields property can only contain items of \StructType\Api_OrderFormFieldTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderFormFields[] = $item;
        return $this;
    }
    /**
     * Get orderItemNumber value
     * @return \StructType\Api_Long|null
     */
    public function getOrderItemNumber()
    {
        return $this->orderItemNumber;
    }
    /**
     * Set orderItemNumber value
     * @param \StructType\Api_Long $orderItemNumber
     * @return \StructType\Api_OrderItemTO
     */
    public function setOrderItemNumber(\StructType\Api_Long $orderItemNumber = null)
    {
        $this->orderItemNumber = $orderItemNumber;
        return $this;
    }
    /**
     * Get orderItemStatusList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_OrderStatusTO[]|null
     */
    public function getOrderItemStatusList()
    {
        return isset($this->orderItemStatusList) ? $this->orderItemStatusList : null;
    }
    /**
     * Set orderItemStatusList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderStatusTO[] $orderItemStatusList
     * @return \StructType\Api_OrderItemTO
     */
    public function setOrderItemStatusList(array $orderItemStatusList = array())
    {
        foreach ($orderItemStatusList as $api_OrderItemTOOrderItemStatusListItem) {
            // validation for constraint: itemType
            if (!$api_OrderItemTOOrderItemStatusListItem instanceof \StructType\Api_OrderStatusTO) {
                throw new \InvalidArgumentException(sprintf('The orderItemStatusList property can only contain items of \StructType\Api_OrderStatusTO, "%s" given', is_object($api_OrderItemTOOrderItemStatusListItem) ? get_class($api_OrderItemTOOrderItemStatusListItem) : gettype($api_OrderItemTOOrderItemStatusListItem)), __LINE__);
            }
        }
        if (is_null($orderItemStatusList) || (is_array($orderItemStatusList) && empty($orderItemStatusList))) {
            unset($this->orderItemStatusList);
        } else {
            $this->orderItemStatusList = $orderItemStatusList;
        }
        return $this;
    }
    /**
     * Add item to orderItemStatusList value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_OrderStatusTO $item
     * @return \StructType\Api_OrderItemTO
     */
    public function addToOrderItemStatusList(\StructType\Api_OrderStatusTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_OrderStatusTO) {
            throw new \InvalidArgumentException(sprintf('The orderItemStatusList property can only contain items of \StructType\Api_OrderStatusTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItemStatusList[] = $item;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Api_OrderItemTO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get plannedFrom value
     * @return \StructType\Api_Date|null
     */
    public function getPlannedFrom()
    {
        return $this->plannedFrom;
    }
    /**
     * Set plannedFrom value
     * @param \StructType\Api_Date $plannedFrom
     * @return \StructType\Api_OrderItemTO
     */
    public function setPlannedFrom(\StructType\Api_Date $plannedFrom = null)
    {
        $this->plannedFrom = $plannedFrom;
        return $this;
    }
    /**
     * Get plannedTo value
     * @return \StructType\Api_Date|null
     */
    public function getPlannedTo()
    {
        return $this->plannedTo;
    }
    /**
     * Set plannedTo value
     * @param \StructType\Api_Date $plannedTo
     * @return \StructType\Api_OrderItemTO
     */
    public function setPlannedTo(\StructType\Api_Date $plannedTo = null)
    {
        $this->plannedTo = $plannedTo;
        return $this;
    }
    /**
     * Get poiId value
     * @return \StructType\Api_PoiId|null
     */
    public function getPoiId()
    {
        return $this->poiId;
    }
    /**
     * Set poiId value
     * @param \StructType\Api_PoiId $poiId
     * @return \StructType\Api_OrderItemTO
     */
    public function setPoiId(\StructType\Api_PoiId $poiId = null)
    {
        $this->poiId = $poiId;
        return $this;
    }
    /**
     * Get sendStatus value
     * @return string|null
     */
    public function getSendStatus()
    {
        return $this->sendStatus;
    }
    /**
     * Set sendStatus value
     * @param string $sendStatus
     * @return \StructType\Api_OrderItemTO
     */
    public function setSendStatus($sendStatus = null)
    {
        // validation for constraint: string
        if (!is_null($sendStatus) && !is_string($sendStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendStatus)), __LINE__);
        }
        $this->sendStatus = $sendStatus;
        return $this;
    }
    /**
     * Get templateId value
     * @return \StructType\Api_Long|null
     */
    public function getTemplateId()
    {
        return $this->templateId;
    }
    /**
     * Set templateId value
     * @param \StructType\Api_Long $templateId
     * @return \StructType\Api_OrderItemTO
     */
    public function setTemplateId(\StructType\Api_Long $templateId = null)
    {
        $this->templateId = $templateId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderItemTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
