<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderGetMinimumOrderTO StructType
 * @subpackage Structs
 */
class Api_OrderGetMinimumOrderTO extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $orderNumber;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_SessionId
     */
    public $sessionId;
    /**
     * Constructor method for Api_OrderGetMinimumOrderTO
     * @uses Api_OrderGetMinimumOrderTO::setOrderNumber()
     * @uses Api_OrderGetMinimumOrderTO::setSessionId()
     * @param string $orderNumber
     * @param \StructType\Api_SessionId $sessionId
     */
    public function __construct($orderNumber = null, \StructType\Api_SessionId $sessionId = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setSessionId($sessionId);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Api_OrderGetMinimumOrderTO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get sessionId value
     * @return \StructType\Api_SessionId|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param \StructType\Api_SessionId $sessionId
     * @return \StructType\Api_OrderGetMinimumOrderTO
     */
    public function setSessionId(\StructType\Api_SessionId $sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderGetMinimumOrderTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
