<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderDeleteOrderItemTO StructType
 * @subpackage Structs
 */
class Api_OrderDeleteOrderItemTO extends AbstractStructBase
{
    /**
     * The orderItemIndex
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Long
     */
    public $orderItemIndex;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $orderNumber;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_SessionId
     */
    public $sessionId;
    /**
     * Constructor method for Api_OrderDeleteOrderItemTO
     * @uses Api_OrderDeleteOrderItemTO::setOrderItemIndex()
     * @uses Api_OrderDeleteOrderItemTO::setOrderNumber()
     * @uses Api_OrderDeleteOrderItemTO::setSessionId()
     * @param \StructType\Api_Long $orderItemIndex
     * @param string $orderNumber
     * @param \StructType\Api_SessionId $sessionId
     */
    public function __construct(\StructType\Api_Long $orderItemIndex = null, $orderNumber = null, \StructType\Api_SessionId $sessionId = null)
    {
        $this
            ->setOrderItemIndex($orderItemIndex)
            ->setOrderNumber($orderNumber)
            ->setSessionId($sessionId);
    }
    /**
     * Get orderItemIndex value
     * @return \StructType\Api_Long|null
     */
    public function getOrderItemIndex()
    {
        return $this->orderItemIndex;
    }
    /**
     * Set orderItemIndex value
     * @param \StructType\Api_Long $orderItemIndex
     * @return \StructType\Api_OrderDeleteOrderItemTO
     */
    public function setOrderItemIndex(\StructType\Api_Long $orderItemIndex = null)
    {
        $this->orderItemIndex = $orderItemIndex;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Api_OrderDeleteOrderItemTO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get sessionId value
     * @return \StructType\Api_SessionId|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param \StructType\Api_SessionId $sessionId
     * @return \StructType\Api_OrderDeleteOrderItemTO
     */
    public function setSessionId(\StructType\Api_SessionId $sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderDeleteOrderItemTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
