<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderAssignOrderToUserTO StructType
 * @subpackage Structs
 */
class Api_OrderAssignOrderToUserTO extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $orderNumber;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_SessionId
     */
    public $sessionId;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_UserId
     */
    public $userId;
    /**
     * Constructor method for Api_OrderAssignOrderToUserTO
     * @uses Api_OrderAssignOrderToUserTO::setOrderNumber()
     * @uses Api_OrderAssignOrderToUserTO::setSessionId()
     * @uses Api_OrderAssignOrderToUserTO::setUserId()
     * @param string $orderNumber
     * @param \StructType\Api_SessionId $sessionId
     * @param \StructType\Api_UserId $userId
     */
    public function __construct($orderNumber = null, \StructType\Api_SessionId $sessionId = null, \StructType\Api_UserId $userId = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setSessionId($sessionId)
            ->setUserId($userId);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\Api_OrderAssignOrderToUserTO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get sessionId value
     * @return \StructType\Api_SessionId|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param \StructType\Api_SessionId $sessionId
     * @return \StructType\Api_OrderAssignOrderToUserTO
     */
    public function setSessionId(\StructType\Api_SessionId $sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get userId value
     * @return \StructType\Api_UserId|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param \StructType\Api_UserId $userId
     * @return \StructType\Api_OrderAssignOrderToUserTO
     */
    public function setUserId(\StructType\Api_UserId $userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderAssignOrderToUserTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
