<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_MessageTO StructType
 * @subpackage Structs
 */
class Api_MessageTO extends AbstractStructBase
{
    /**
     * The fromUserId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_UserId
     */
    public $fromUserId;
    /**
     * The fromVehicleId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_VehicleId
     */
    public $fromVehicleId;
    /**
     * The isRead
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $isRead;
    /**
     * The messageData
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $messageData;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_MessageId
     */
    public $messageId;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $timestamp;
    /**
     * Constructor method for Api_MessageTO
     * @uses Api_MessageTO::setFromUserId()
     * @uses Api_MessageTO::setFromVehicleId()
     * @uses Api_MessageTO::setIsRead()
     * @uses Api_MessageTO::setMessageData()
     * @uses Api_MessageTO::setMessageId()
     * @uses Api_MessageTO::setTimestamp()
     * @param \StructType\Api_UserId $fromUserId
     * @param \StructType\Api_VehicleId $fromVehicleId
     * @param \StructType\Api_Boolean $isRead
     * @param string $messageData
     * @param \StructType\Api_MessageId $messageId
     * @param \StructType\Api_Date $timestamp
     */
    public function __construct(\StructType\Api_UserId $fromUserId = null, \StructType\Api_VehicleId $fromVehicleId = null, \StructType\Api_Boolean $isRead = null, $messageData = null, \StructType\Api_MessageId $messageId = null, \StructType\Api_Date $timestamp = null)
    {
        $this
            ->setFromUserId($fromUserId)
            ->setFromVehicleId($fromVehicleId)
            ->setIsRead($isRead)
            ->setMessageData($messageData)
            ->setMessageId($messageId)
            ->setTimestamp($timestamp);
    }
    /**
     * Get fromUserId value
     * @return \StructType\Api_UserId|null
     */
    public function getFromUserId()
    {
        return $this->fromUserId;
    }
    /**
     * Set fromUserId value
     * @param \StructType\Api_UserId $fromUserId
     * @return \StructType\Api_MessageTO
     */
    public function setFromUserId(\StructType\Api_UserId $fromUserId = null)
    {
        $this->fromUserId = $fromUserId;
        return $this;
    }
    /**
     * Get fromVehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getFromVehicleId()
    {
        return $this->fromVehicleId;
    }
    /**
     * Set fromVehicleId value
     * @param \StructType\Api_VehicleId $fromVehicleId
     * @return \StructType\Api_MessageTO
     */
    public function setFromVehicleId(\StructType\Api_VehicleId $fromVehicleId = null)
    {
        $this->fromVehicleId = $fromVehicleId;
        return $this;
    }
    /**
     * Get isRead value
     * @return \StructType\Api_Boolean|null
     */
    public function getIsRead()
    {
        return $this->isRead;
    }
    /**
     * Set isRead value
     * @param \StructType\Api_Boolean $isRead
     * @return \StructType\Api_MessageTO
     */
    public function setIsRead(\StructType\Api_Boolean $isRead = null)
    {
        $this->isRead = $isRead;
        return $this;
    }
    /**
     * Get messageData value
     * @return string|null
     */
    public function getMessageData()
    {
        return $this->messageData;
    }
    /**
     * Set messageData value
     * @param string $messageData
     * @return \StructType\Api_MessageTO
     */
    public function setMessageData($messageData = null)
    {
        // validation for constraint: string
        if (!is_null($messageData) && !is_string($messageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageData)), __LINE__);
        }
        $this->messageData = $messageData;
        return $this;
    }
    /**
     * Get messageId value
     * @return \StructType\Api_MessageId|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param \StructType\Api_MessageId $messageId
     * @return \StructType\Api_MessageTO
     */
    public function setMessageId(\StructType\Api_MessageId $messageId = null)
    {
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return \StructType\Api_Date|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param \StructType\Api_Date $timestamp
     * @return \StructType\Api_MessageTO
     */
    public function setTimestamp(\StructType\Api_Date $timestamp = null)
    {
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_MessageTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
