<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_FormMessageWithDestinationPointTO StructType
 * @subpackage Structs
 */
class Api_FormMessageWithDestinationPointTO extends AbstractStructBase
{
    /**
     * The formId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_FormId
     */
    public $formId;
    /**
     * The isRead
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $isRead;
    /**
     * The messageData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\Api_FormMessageFieldTO[]
     */
    public $messageData;
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_FormMessageId
     */
    public $messageId;
    /**
     * The point
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_PointTO
     */
    public $point;
    /**
     * The sendstatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sendstatus;
    /**
     * The sendstatusLastChangeTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $sendstatusLastChangeTime;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $timestamp;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_UserId
     */
    public $userId;
    /**
     * The vehicleId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_VehicleId
     */
    public $vehicleId;
    /**
     * Constructor method for Api_FormMessageWithDestinationPointTO
     * @uses Api_FormMessageWithDestinationPointTO::setFormId()
     * @uses Api_FormMessageWithDestinationPointTO::setIsRead()
     * @uses Api_FormMessageWithDestinationPointTO::setMessageData()
     * @uses Api_FormMessageWithDestinationPointTO::setMessageId()
     * @uses Api_FormMessageWithDestinationPointTO::setPoint()
     * @uses Api_FormMessageWithDestinationPointTO::setSendstatus()
     * @uses Api_FormMessageWithDestinationPointTO::setSendstatusLastChangeTime()
     * @uses Api_FormMessageWithDestinationPointTO::setTimestamp()
     * @uses Api_FormMessageWithDestinationPointTO::setUserId()
     * @uses Api_FormMessageWithDestinationPointTO::setVehicleId()
     * @param \StructType\Api_FormId $formId
     * @param \StructType\Api_Boolean $isRead
     * @param \StructType\Api_FormMessageFieldTO[] $messageData
     * @param \StructType\Api_FormMessageId $messageId
     * @param \StructType\Api_PointTO $point
     * @param string $sendstatus
     * @param \StructType\Api_Date $sendstatusLastChangeTime
     * @param \StructType\Api_Date $timestamp
     * @param \StructType\Api_UserId $userId
     * @param \StructType\Api_VehicleId $vehicleId
     */
    public function __construct(\StructType\Api_FormId $formId = null, \StructType\Api_Boolean $isRead = null, array $messageData = array(), \StructType\Api_FormMessageId $messageId = null, \StructType\Api_PointTO $point = null, $sendstatus = null, \StructType\Api_Date $sendstatusLastChangeTime = null, \StructType\Api_Date $timestamp = null, \StructType\Api_UserId $userId = null, \StructType\Api_VehicleId $vehicleId = null)
    {
        $this
            ->setFormId($formId)
            ->setIsRead($isRead)
            ->setMessageData($messageData)
            ->setMessageId($messageId)
            ->setPoint($point)
            ->setSendstatus($sendstatus)
            ->setSendstatusLastChangeTime($sendstatusLastChangeTime)
            ->setTimestamp($timestamp)
            ->setUserId($userId)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get formId value
     * @return \StructType\Api_FormId|null
     */
    public function getFormId()
    {
        return $this->formId;
    }
    /**
     * Set formId value
     * @param \StructType\Api_FormId $formId
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setFormId(\StructType\Api_FormId $formId = null)
    {
        $this->formId = $formId;
        return $this;
    }
    /**
     * Get isRead value
     * @return \StructType\Api_Boolean|null
     */
    public function getIsRead()
    {
        return $this->isRead;
    }
    /**
     * Set isRead value
     * @param \StructType\Api_Boolean $isRead
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setIsRead(\StructType\Api_Boolean $isRead = null)
    {
        $this->isRead = $isRead;
        return $this;
    }
    /**
     * Get messageData value
     * @return \StructType\Api_FormMessageFieldTO[]|null
     */
    public function getMessageData()
    {
        return $this->messageData;
    }
    /**
     * Set messageData value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_FormMessageFieldTO[] $messageData
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setMessageData(array $messageData = array())
    {
        foreach ($messageData as $api_FormMessageWithDestinationPointTOMessageDataItem) {
            // validation for constraint: itemType
            if (!$api_FormMessageWithDestinationPointTOMessageDataItem instanceof \StructType\Api_FormMessageFieldTO) {
                throw new \InvalidArgumentException(sprintf('The messageData property can only contain items of \StructType\Api_FormMessageFieldTO, "%s" given', is_object($api_FormMessageWithDestinationPointTOMessageDataItem) ? get_class($api_FormMessageWithDestinationPointTOMessageDataItem) : gettype($api_FormMessageWithDestinationPointTOMessageDataItem)), __LINE__);
            }
        }
        $this->messageData = $messageData;
        return $this;
    }
    /**
     * Add item to messageData value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_FormMessageFieldTO $item
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function addToMessageData(\StructType\Api_FormMessageFieldTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_FormMessageFieldTO) {
            throw new \InvalidArgumentException(sprintf('The messageData property can only contain items of \StructType\Api_FormMessageFieldTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->messageData[] = $item;
        return $this;
    }
    /**
     * Get messageId value
     * @return \StructType\Api_FormMessageId|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param \StructType\Api_FormMessageId $messageId
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setMessageId(\StructType\Api_FormMessageId $messageId = null)
    {
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get point value
     * @return \StructType\Api_PointTO|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param \StructType\Api_PointTO $point
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setPoint(\StructType\Api_PointTO $point = null)
    {
        $this->point = $point;
        return $this;
    }
    /**
     * Get sendstatus value
     * @return string|null
     */
    public function getSendstatus()
    {
        return $this->sendstatus;
    }
    /**
     * Set sendstatus value
     * @param string $sendstatus
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setSendstatus($sendstatus = null)
    {
        // validation for constraint: string
        if (!is_null($sendstatus) && !is_string($sendstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendstatus)), __LINE__);
        }
        $this->sendstatus = $sendstatus;
        return $this;
    }
    /**
     * Get sendstatusLastChangeTime value
     * @return \StructType\Api_Date|null
     */
    public function getSendstatusLastChangeTime()
    {
        return $this->sendstatusLastChangeTime;
    }
    /**
     * Set sendstatusLastChangeTime value
     * @param \StructType\Api_Date $sendstatusLastChangeTime
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setSendstatusLastChangeTime(\StructType\Api_Date $sendstatusLastChangeTime = null)
    {
        $this->sendstatusLastChangeTime = $sendstatusLastChangeTime;
        return $this;
    }
    /**
     * Get timestamp value
     * @return \StructType\Api_Date|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param \StructType\Api_Date $timestamp
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setTimestamp(\StructType\Api_Date $timestamp = null)
    {
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get userId value
     * @return \StructType\Api_UserId|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param \StructType\Api_UserId $userId
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setUserId(\StructType\Api_UserId $userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get vehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param \StructType\Api_VehicleId $vehicleId
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public function setVehicleId(\StructType\Api_VehicleId $vehicleId = null)
    {
        $this->vehicleId = $vehicleId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_FormMessageWithDestinationPointTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
