<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_FleetInfoTO StructType
 * @subpackage Structs
 */
class Api_FleetInfoTO extends AbstractStructBase
{
    /**
     * The customerDisplayname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $customerDisplayname;
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $displayName;
    /**
     * The emailAlias
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emailAlias;
    /**
     * The fleetId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $fleetId;
    /**
     * The isDeleted
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Boolean
     */
    public $isDeleted;
    /**
     * The measureType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $measureType;
    /**
     * Constructor method for Api_FleetInfoTO
     * @uses Api_FleetInfoTO::setCustomerDisplayname()
     * @uses Api_FleetInfoTO::setDisplayName()
     * @uses Api_FleetInfoTO::setEmailAlias()
     * @uses Api_FleetInfoTO::setFleetId()
     * @uses Api_FleetInfoTO::setIsDeleted()
     * @uses Api_FleetInfoTO::setMeasureType()
     * @param string $customerDisplayname
     * @param string $displayName
     * @param string $emailAlias
     * @param \StructType\Api_Long $fleetId
     * @param \StructType\Api_Boolean $isDeleted
     * @param string $measureType
     */
    public function __construct($customerDisplayname = null, $displayName = null, $emailAlias = null, \StructType\Api_Long $fleetId = null, \StructType\Api_Boolean $isDeleted = null, $measureType = null)
    {
        $this
            ->setCustomerDisplayname($customerDisplayname)
            ->setDisplayName($displayName)
            ->setEmailAlias($emailAlias)
            ->setFleetId($fleetId)
            ->setIsDeleted($isDeleted)
            ->setMeasureType($measureType);
    }
    /**
     * Get customerDisplayname value
     * @return string|null
     */
    public function getCustomerDisplayname()
    {
        return $this->customerDisplayname;
    }
    /**
     * Set customerDisplayname value
     * @param string $customerDisplayname
     * @return \StructType\Api_FleetInfoTO
     */
    public function setCustomerDisplayname($customerDisplayname = null)
    {
        // validation for constraint: string
        if (!is_null($customerDisplayname) && !is_string($customerDisplayname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerDisplayname)), __LINE__);
        }
        $this->customerDisplayname = $customerDisplayname;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\Api_FleetInfoTO
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get emailAlias value
     * @return string|null
     */
    public function getEmailAlias()
    {
        return $this->emailAlias;
    }
    /**
     * Set emailAlias value
     * @param string $emailAlias
     * @return \StructType\Api_FleetInfoTO
     */
    public function setEmailAlias($emailAlias = null)
    {
        // validation for constraint: string
        if (!is_null($emailAlias) && !is_string($emailAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAlias)), __LINE__);
        }
        $this->emailAlias = $emailAlias;
        return $this;
    }
    /**
     * Get fleetId value
     * @return \StructType\Api_Long|null
     */
    public function getFleetId()
    {
        return $this->fleetId;
    }
    /**
     * Set fleetId value
     * @param \StructType\Api_Long $fleetId
     * @return \StructType\Api_FleetInfoTO
     */
    public function setFleetId(\StructType\Api_Long $fleetId = null)
    {
        $this->fleetId = $fleetId;
        return $this;
    }
    /**
     * Get isDeleted value
     * @return \StructType\Api_Boolean|null
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }
    /**
     * Set isDeleted value
     * @param \StructType\Api_Boolean $isDeleted
     * @return \StructType\Api_FleetInfoTO
     */
    public function setIsDeleted(\StructType\Api_Boolean $isDeleted = null)
    {
        $this->isDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get measureType value
     * @return string|null
     */
    public function getMeasureType()
    {
        return $this->measureType;
    }
    /**
     * Set measureType value
     * @param string $measureType
     * @return \StructType\Api_FleetInfoTO
     */
    public function setMeasureType($measureType = null)
    {
        // validation for constraint: string
        if (!is_null($measureType) && !is_string($measureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measureType)), __LINE__);
        }
        $this->measureType = $measureType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_FleetInfoTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
