<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_DtjDataTO StructType
 * @subpackage Structs
 */
class Api_DtjDataTO extends AbstractStructBase
{
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $driverId;
    /**
     * The dtjDataEntries
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_DtjDataEntryTO[]
     */
    public $dtjDataEntries;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastName;
    /**
     * Constructor method for Api_DtjDataTO
     * @uses Api_DtjDataTO::setDriverId()
     * @uses Api_DtjDataTO::setDtjDataEntries()
     * @uses Api_DtjDataTO::setFirstName()
     * @uses Api_DtjDataTO::setLastName()
     * @param \StructType\Api_Long $driverId
     * @param \StructType\Api_DtjDataEntryTO[] $dtjDataEntries
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct(\StructType\Api_Long $driverId = null, array $dtjDataEntries = array(), $firstName = null, $lastName = null)
    {
        $this
            ->setDriverId($driverId)
            ->setDtjDataEntries($dtjDataEntries)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get driverId value
     * @return \StructType\Api_Long|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param \StructType\Api_Long $driverId
     * @return \StructType\Api_DtjDataTO
     */
    public function setDriverId(\StructType\Api_Long $driverId = null)
    {
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get dtjDataEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_DtjDataEntryTO[]|null
     */
    public function getDtjDataEntries()
    {
        return isset($this->dtjDataEntries) ? $this->dtjDataEntries : null;
    }
    /**
     * Set dtjDataEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DtjDataEntryTO[] $dtjDataEntries
     * @return \StructType\Api_DtjDataTO
     */
    public function setDtjDataEntries(array $dtjDataEntries = array())
    {
        foreach ($dtjDataEntries as $api_DtjDataTODtjDataEntriesItem) {
            // validation for constraint: itemType
            if (!$api_DtjDataTODtjDataEntriesItem instanceof \StructType\Api_DtjDataEntryTO) {
                throw new \InvalidArgumentException(sprintf('The dtjDataEntries property can only contain items of \StructType\Api_DtjDataEntryTO, "%s" given', is_object($api_DtjDataTODtjDataEntriesItem) ? get_class($api_DtjDataTODtjDataEntriesItem) : gettype($api_DtjDataTODtjDataEntriesItem)), __LINE__);
            }
        }
        if (is_null($dtjDataEntries) || (is_array($dtjDataEntries) && empty($dtjDataEntries))) {
            unset($this->dtjDataEntries);
        } else {
            $this->dtjDataEntries = $dtjDataEntries;
        }
        return $this;
    }
    /**
     * Add item to dtjDataEntries value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DtjDataEntryTO $item
     * @return \StructType\Api_DtjDataTO
     */
    public function addToDtjDataEntries(\StructType\Api_DtjDataEntryTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_DtjDataEntryTO) {
            throw new \InvalidArgumentException(sprintf('The dtjDataEntries property can only contain items of \StructType\Api_DtjDataEntryTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dtjDataEntries[] = $item;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Api_DtjDataTO
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Api_DtjDataTO
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_DtjDataTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
