<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_DriverInfoV2TO StructType
 * @subpackage Structs
 */
class Api_DriverInfoV2TO extends AbstractStructBase
{
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $displayName;
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_DriverId
     */
    public $driverId;
    /**
     * The digitalTachoCardId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $digitalTachoCardId;
    /**
     * The cardRegistredTo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardRegistredTo;
    /**
     * Constructor method for Api_DriverInfoV2TO
     * @uses Api_DriverInfoV2TO::setDisplayName()
     * @uses Api_DriverInfoV2TO::setDriverId()
     * @uses Api_DriverInfoV2TO::setDigitalTachoCardId()
     * @uses Api_DriverInfoV2TO::setCardRegistredTo()
     * @param string $displayName
     * @param \StructType\Api_DriverId $driverId
     * @param string $digitalTachoCardId
     * @param string $cardRegistredTo
     */
    public function __construct($displayName = null, \StructType\Api_DriverId $driverId = null, $digitalTachoCardId = null, $cardRegistredTo = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDriverId($driverId)
            ->setDigitalTachoCardId($digitalTachoCardId)
            ->setCardRegistredTo($cardRegistredTo);
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\Api_DriverInfoV2TO
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get driverId value
     * @return \StructType\Api_DriverId|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param \StructType\Api_DriverId $driverId
     * @return \StructType\Api_DriverInfoV2TO
     */
    public function setDriverId(\StructType\Api_DriverId $driverId = null)
    {
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get digitalTachoCardId value
     * @return string|null
     */
    public function getDigitalTachoCardId()
    {
        return $this->digitalTachoCardId;
    }
    /**
     * Set digitalTachoCardId value
     * @param string $digitalTachoCardId
     * @return \StructType\Api_DriverInfoV2TO
     */
    public function setDigitalTachoCardId($digitalTachoCardId = null)
    {
        // validation for constraint: string
        if (!is_null($digitalTachoCardId) && !is_string($digitalTachoCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digitalTachoCardId)), __LINE__);
        }
        $this->digitalTachoCardId = $digitalTachoCardId;
        return $this;
    }
    /**
     * Get cardRegistredTo value
     * @return string|null
     */
    public function getCardRegistredTo()
    {
        return $this->cardRegistredTo;
    }
    /**
     * Set cardRegistredTo value
     * @param string $cardRegistredTo
     * @return \StructType\Api_DriverInfoV2TO
     */
    public function setCardRegistredTo($cardRegistredTo = null)
    {
        // validation for constraint: string
        if (!is_null($cardRegistredTo) && !is_string($cardRegistredTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardRegistredTo)), __LINE__);
        }
        $this->cardRegistredTo = $cardRegistredTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_DriverInfoV2TO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
