<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_DriverDataTO StructType
 * @subpackage Structs
 */
class Api_DriverDataTO extends AbstractStructBase
{
    /**
     * The dataEntries
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_DriverDataEntryTO[]
     */
    public $dataEntries;
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $driverId;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastName;
    /**
     * Constructor method for Api_DriverDataTO
     * @uses Api_DriverDataTO::setDataEntries()
     * @uses Api_DriverDataTO::setDriverId()
     * @uses Api_DriverDataTO::setFirstName()
     * @uses Api_DriverDataTO::setLastName()
     * @param \StructType\Api_DriverDataEntryTO[] $dataEntries
     * @param \StructType\Api_Long $driverId
     * @param string $firstName
     * @param string $lastName
     */
    public function __construct(array $dataEntries = array(), \StructType\Api_Long $driverId = null, $firstName = null, $lastName = null)
    {
        $this
            ->setDataEntries($dataEntries)
            ->setDriverId($driverId)
            ->setFirstName($firstName)
            ->setLastName($lastName);
    }
    /**
     * Get dataEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_DriverDataEntryTO[]|null
     */
    public function getDataEntries()
    {
        return isset($this->dataEntries) ? $this->dataEntries : null;
    }
    /**
     * Set dataEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverDataEntryTO[] $dataEntries
     * @return \StructType\Api_DriverDataTO
     */
    public function setDataEntries(array $dataEntries = array())
    {
        foreach ($dataEntries as $api_DriverDataTODataEntriesItem) {
            // validation for constraint: itemType
            if (!$api_DriverDataTODataEntriesItem instanceof \StructType\Api_DriverDataEntryTO) {
                throw new \InvalidArgumentException(sprintf('The dataEntries property can only contain items of \StructType\Api_DriverDataEntryTO, "%s" given', is_object($api_DriverDataTODataEntriesItem) ? get_class($api_DriverDataTODataEntriesItem) : gettype($api_DriverDataTODataEntriesItem)), __LINE__);
            }
        }
        if (is_null($dataEntries) || (is_array($dataEntries) && empty($dataEntries))) {
            unset($this->dataEntries);
        } else {
            $this->dataEntries = $dataEntries;
        }
        return $this;
    }
    /**
     * Add item to dataEntries value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverDataEntryTO $item
     * @return \StructType\Api_DriverDataTO
     */
    public function addToDataEntries(\StructType\Api_DriverDataEntryTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_DriverDataEntryTO) {
            throw new \InvalidArgumentException(sprintf('The dataEntries property can only contain items of \StructType\Api_DriverDataEntryTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dataEntries[] = $item;
        return $this;
    }
    /**
     * Get driverId value
     * @return \StructType\Api_Long|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param \StructType\Api_Long $driverId
     * @return \StructType\Api_DriverDataTO
     */
    public function setDriverId(\StructType\Api_Long $driverId = null)
    {
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Api_DriverDataTO
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Api_DriverDataTO
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_DriverDataTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
