<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named storeNewOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StoreNewOrder $parameters
     * @return \StructType\StoreNewOrderResponse|bool
     */
    public function storeNewOrder(\StructType\StoreNewOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeNewOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeDTMAlarmSetting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StoreDTMAlarmSetting $parameters
     * @return \StructType\StoreDTMAlarmSettingResponse|bool
     */
    public function storeDTMAlarmSetting(\StructType\StoreDTMAlarmSetting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeDTMAlarmSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StoreDTMAlarmSettingResponse|\StructType\StoreNewOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
