<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modify ServiceType
 * @subpackage Services
 */
class Modify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named modifyCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyCustomer $parameters
     * @return \StructType\ModifyCustomerResponse|bool
     */
    public function modifyCustomer(\StructType\ModifyCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyPoi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyPoi $parameters
     * @return \StructType\ModifyPoiResponse|bool
     */
    public function modifyPoi(\StructType\ModifyPoi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyPoi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named modifyGeofencePlus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModifyGeofencePlus $parameters
     * @return \StructType\ModifyGeofencePlusResponse|bool
     */
    public function modifyGeofencePlus(\StructType\ModifyGeofencePlus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->modifyGeofencePlus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ModifyCustomerResponse|\StructType\ModifyGeofencePlusResponse|\StructType\ModifyPoiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
