<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteCompletedOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCompletedOrder $parameters
     * @return \StructType\DeleteCompletedOrderResponse|bool
     */
    public function deleteCompletedOrder(\StructType\DeleteCompletedOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCompletedOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteOrderItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteOrderItem $parameters
     * @return \StructType\DeleteOrderItemResponse|bool
     */
    public function deleteOrderItem(\StructType\DeleteOrderItem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteOrderItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomer $parameters
     * @return \StructType\DeleteCustomerResponse|bool
     */
    public function deleteCustomer(\StructType\DeleteCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMessage $parameters
     * @return \StructType\DeleteMessageResponse|bool
     */
    public function deleteMessage(\StructType\DeleteMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteMessagesByTimestamp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMessagesByTimestamp $parameters
     * @return \StructType\DeleteMessagesByTimestampResponse|bool
     */
    public function deleteMessagesByTimestamp(\StructType\DeleteMessagesByTimestamp $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteMessagesByTimestamp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteReadMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReadMessages $parameters
     * @return \StructType\DeleteReadMessagesResponse|bool
     */
    public function deleteReadMessages(\StructType\DeleteReadMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteReadMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deletePoi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeletePoi $parameters
     * @return \StructType\DeletePoiResponse|bool
     */
    public function deletePoi(\StructType\DeletePoi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deletePoi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteFormMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteFormMessage $parameters
     * @return \StructType\DeleteFormMessageResponse|bool
     */
    public function deleteFormMessage(\StructType\DeleteFormMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteFormMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteFormMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteFormMessages $parameters
     * @return \StructType\DeleteFormMessagesResponse|bool
     */
    public function deleteFormMessages(\StructType\DeleteFormMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteFormMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteCompletedOrderResponse|\StructType\DeleteCustomerResponse|\StructType\DeleteFormMessageResponse|\StructType\DeleteFormMessagesResponse|\StructType\DeleteMessageResponse|\StructType\DeleteMessagesByTimestampResponse|\StructType\DeleteOrderItemResponse|\StructType\DeletePoiResponse|\StructType\DeleteReadMessagesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
