<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_VehicleDataExtendedTO StructType
 * @subpackage Structs
 */
class Api_VehicleDataExtendedTO extends AbstractStructBase
{
    /**
     * The dataEntries
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_VehicleDataEntryExtendedTO[]
     */
    public $dataEntries;
    /**
     * The vehicleId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_VehicleId
     */
    public $vehicleId;
    /**
     * Constructor method for Api_VehicleDataExtendedTO
     * @uses Api_VehicleDataExtendedTO::setDataEntries()
     * @uses Api_VehicleDataExtendedTO::setVehicleId()
     * @param \StructType\Api_VehicleDataEntryExtendedTO[] $dataEntries
     * @param \StructType\Api_VehicleId $vehicleId
     */
    public function __construct(array $dataEntries = array(), \StructType\Api_VehicleId $vehicleId = null)
    {
        $this
            ->setDataEntries($dataEntries)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get dataEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_VehicleDataEntryExtendedTO[]|null
     */
    public function getDataEntries()
    {
        return isset($this->dataEntries) ? $this->dataEntries : null;
    }
    /**
     * Set dataEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleDataEntryExtendedTO[] $dataEntries
     * @return \StructType\Api_VehicleDataExtendedTO
     */
    public function setDataEntries(array $dataEntries = array())
    {
        foreach ($dataEntries as $api_VehicleDataExtendedTODataEntriesItem) {
            // validation for constraint: itemType
            if (!$api_VehicleDataExtendedTODataEntriesItem instanceof \StructType\Api_VehicleDataEntryExtendedTO) {
                throw new \InvalidArgumentException(sprintf('The dataEntries property can only contain items of \StructType\Api_VehicleDataEntryExtendedTO, "%s" given', is_object($api_VehicleDataExtendedTODataEntriesItem) ? get_class($api_VehicleDataExtendedTODataEntriesItem) : gettype($api_VehicleDataExtendedTODataEntriesItem)), __LINE__);
            }
        }
        if (is_null($dataEntries) || (is_array($dataEntries) && empty($dataEntries))) {
            unset($this->dataEntries);
        } else {
            $this->dataEntries = $dataEntries;
        }
        return $this;
    }
    /**
     * Add item to dataEntries value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleDataEntryExtendedTO $item
     * @return \StructType\Api_VehicleDataExtendedTO
     */
    public function addToDataEntries(\StructType\Api_VehicleDataEntryExtendedTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_VehicleDataEntryExtendedTO) {
            throw new \InvalidArgumentException(sprintf('The dataEntries property can only contain items of \StructType\Api_VehicleDataEntryExtendedTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dataEntries[] = $item;
        return $this;
    }
    /**
     * Get vehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param \StructType\Api_VehicleId $vehicleId
     * @return \StructType\Api_VehicleDataExtendedTO
     */
    public function setVehicleId(\StructType\Api_VehicleId $vehicleId = null)
    {
        $this->vehicleId = $vehicleId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_VehicleDataExtendedTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
