<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_OrderStatusTO StructType
 * @subpackage Structs
 */
class Api_OrderStatusTO extends AbstractStructBase
{
    /**
     * The orderItemStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderItemStatus;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $timestamp;
    /**
     * The vehicleStatus
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_TrackingDataTO
     */
    public $vehicleStatus;
    /**
     * Constructor method for Api_OrderStatusTO
     * @uses Api_OrderStatusTO::setOrderItemStatus()
     * @uses Api_OrderStatusTO::setTimestamp()
     * @uses Api_OrderStatusTO::setVehicleStatus()
     * @param string $orderItemStatus
     * @param \StructType\Api_Date $timestamp
     * @param \StructType\Api_TrackingDataTO $vehicleStatus
     */
    public function __construct($orderItemStatus = null, \StructType\Api_Date $timestamp = null, \StructType\Api_TrackingDataTO $vehicleStatus = null)
    {
        $this
            ->setOrderItemStatus($orderItemStatus)
            ->setTimestamp($timestamp)
            ->setVehicleStatus($vehicleStatus);
    }
    /**
     * Get orderItemStatus value
     * @return string|null
     */
    public function getOrderItemStatus()
    {
        return $this->orderItemStatus;
    }
    /**
     * Set orderItemStatus value
     * @param string $orderItemStatus
     * @return \StructType\Api_OrderStatusTO
     */
    public function setOrderItemStatus($orderItemStatus = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemStatus) && !is_string($orderItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderItemStatus)), __LINE__);
        }
        $this->orderItemStatus = $orderItemStatus;
        return $this;
    }
    /**
     * Get timestamp value
     * @return \StructType\Api_Date|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param \StructType\Api_Date $timestamp
     * @return \StructType\Api_OrderStatusTO
     */
    public function setTimestamp(\StructType\Api_Date $timestamp = null)
    {
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get vehicleStatus value
     * @return \StructType\Api_TrackingDataTO|null
     */
    public function getVehicleStatus()
    {
        return $this->vehicleStatus;
    }
    /**
     * Set vehicleStatus value
     * @param \StructType\Api_TrackingDataTO $vehicleStatus
     * @return \StructType\Api_OrderStatusTO
     */
    public function setVehicleStatus(\StructType\Api_TrackingDataTO $vehicleStatus = null)
    {
        $this->vehicleStatus = $vehicleStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_OrderStatusTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
