<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_MessageSendMessageWithDestinationPointToVehicleTO
 * StructType
 * @subpackage Structs
 */
class Api_MessageSendMessageWithDestinationPointToVehicleTO extends AbstractStructBase
{
    /**
     * The point
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_PointTO
     */
    public $point;
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_SessionId
     */
    public $sessionId;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $text;
    /**
     * The vehicleId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_VehicleId
     */
    public $vehicleId;
    /**
     * Constructor method for Api_MessageSendMessageWithDestinationPointToVehicleTO
     * @uses Api_MessageSendMessageWithDestinationPointToVehicleTO::setPoint()
     * @uses Api_MessageSendMessageWithDestinationPointToVehicleTO::setSessionId()
     * @uses Api_MessageSendMessageWithDestinationPointToVehicleTO::setText()
     * @uses Api_MessageSendMessageWithDestinationPointToVehicleTO::setVehicleId()
     * @param \StructType\Api_PointTO $point
     * @param \StructType\Api_SessionId $sessionId
     * @param string $text
     * @param \StructType\Api_VehicleId $vehicleId
     */
    public function __construct(\StructType\Api_PointTO $point = null, \StructType\Api_SessionId $sessionId = null, $text = null, \StructType\Api_VehicleId $vehicleId = null)
    {
        $this
            ->setPoint($point)
            ->setSessionId($sessionId)
            ->setText($text)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get point value
     * @return \StructType\Api_PointTO|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param \StructType\Api_PointTO $point
     * @return \StructType\Api_MessageSendMessageWithDestinationPointToVehicleTO
     */
    public function setPoint(\StructType\Api_PointTO $point = null)
    {
        $this->point = $point;
        return $this;
    }
    /**
     * Get sessionId value
     * @return \StructType\Api_SessionId|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param \StructType\Api_SessionId $sessionId
     * @return \StructType\Api_MessageSendMessageWithDestinationPointToVehicleTO
     */
    public function setSessionId(\StructType\Api_SessionId $sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Api_MessageSendMessageWithDestinationPointToVehicleTO
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get vehicleId value
     * @return \StructType\Api_VehicleId|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param \StructType\Api_VehicleId $vehicleId
     * @return \StructType\Api_MessageSendMessageWithDestinationPointToVehicleTO
     */
    public function setVehicleId(\StructType\Api_VehicleId $vehicleId = null)
    {
        $this->vehicleId = $vehicleId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_MessageSendMessageWithDestinationPointToVehicleTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
