<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_GeofenceTO StructType
 * @subpackage Structs
 */
class Api_GeofenceTO extends AbstractStructBase
{
    /**
     * The geofenceId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_GeofenceId
     */
    public $geofenceId;
    /**
     * The geofenceName
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $geofenceName;
    /**
     * The geofenceType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $geofenceType;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for Api_GeofenceTO
     * @uses Api_GeofenceTO::setGeofenceId()
     * @uses Api_GeofenceTO::setGeofenceName()
     * @uses Api_GeofenceTO::setGeofenceType()
     * @uses Api_GeofenceTO::setServiceType()
     * @param \StructType\Api_GeofenceId $geofenceId
     * @param string $geofenceName
     * @param string $geofenceType
     * @param string $serviceType
     */
    public function __construct(\StructType\Api_GeofenceId $geofenceId = null, $geofenceName = null, $geofenceType = null, $serviceType = null)
    {
        $this
            ->setGeofenceId($geofenceId)
            ->setGeofenceName($geofenceName)
            ->setGeofenceType($geofenceType)
            ->setServiceType($serviceType);
    }
    /**
     * Get geofenceId value
     * @return \StructType\Api_GeofenceId|null
     */
    public function getGeofenceId()
    {
        return $this->geofenceId;
    }
    /**
     * Set geofenceId value
     * @param \StructType\Api_GeofenceId $geofenceId
     * @return \StructType\Api_GeofenceTO
     */
    public function setGeofenceId(\StructType\Api_GeofenceId $geofenceId = null)
    {
        $this->geofenceId = $geofenceId;
        return $this;
    }
    /**
     * Get geofenceName value
     * @return string|null
     */
    public function getGeofenceName()
    {
        return $this->geofenceName;
    }
    /**
     * Set geofenceName value
     * @param string $geofenceName
     * @return \StructType\Api_GeofenceTO
     */
    public function setGeofenceName($geofenceName = null)
    {
        // validation for constraint: string
        if (!is_null($geofenceName) && !is_string($geofenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geofenceName)), __LINE__);
        }
        $this->geofenceName = $geofenceName;
        return $this;
    }
    /**
     * Get geofenceType value
     * @return string|null
     */
    public function getGeofenceType()
    {
        return $this->geofenceType;
    }
    /**
     * Set geofenceType value
     * @param string $geofenceType
     * @return \StructType\Api_GeofenceTO
     */
    public function setGeofenceType($geofenceType = null)
    {
        // validation for constraint: string
        if (!is_null($geofenceType) && !is_string($geofenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geofenceType)), __LINE__);
        }
        $this->geofenceType = $geofenceType;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \StructType\Api_GeofenceTO
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_GeofenceTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
