<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_GeofenceRouteTO StructType
 * @subpackage Structs
 */
class Api_GeofenceRouteTO extends AbstractStructBase
{
    /**
     * The deviation
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var \StructType\Api_Integer
     */
    public $deviation;
    /**
     * The waypoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\Api_PointTO[]
     */
    public $waypoints;
    /**
     * Constructor method for Api_GeofenceRouteTO
     * @uses Api_GeofenceRouteTO::setDeviation()
     * @uses Api_GeofenceRouteTO::setWaypoints()
     * @param \StructType\Api_Integer $deviation
     * @param \StructType\Api_PointTO[] $waypoints
     */
    public function __construct(\StructType\Api_Integer $deviation = null, array $waypoints = array())
    {
        $this
            ->setDeviation($deviation)
            ->setWaypoints($waypoints);
    }
    /**
     * Get deviation value
     * @return \StructType\Api_Integer|null
     */
    public function getDeviation()
    {
        return $this->deviation;
    }
    /**
     * Set deviation value
     * @param \StructType\Api_Integer $deviation
     * @return \StructType\Api_GeofenceRouteTO
     */
    public function setDeviation(\StructType\Api_Integer $deviation = null)
    {
        $this->deviation = $deviation;
        return $this;
    }
    /**
     * Get waypoints value
     * @return \StructType\Api_PointTO[]|null
     */
    public function getWaypoints()
    {
        return $this->waypoints;
    }
    /**
     * Set waypoints value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_PointTO[] $waypoints
     * @return \StructType\Api_GeofenceRouteTO
     */
    public function setWaypoints(array $waypoints = array())
    {
        foreach ($waypoints as $api_GeofenceRouteTOWaypointsItem) {
            // validation for constraint: itemType
            if (!$api_GeofenceRouteTOWaypointsItem instanceof \StructType\Api_PointTO) {
                throw new \InvalidArgumentException(sprintf('The waypoints property can only contain items of \StructType\Api_PointTO, "%s" given', is_object($api_GeofenceRouteTOWaypointsItem) ? get_class($api_GeofenceRouteTOWaypointsItem) : gettype($api_GeofenceRouteTOWaypointsItem)), __LINE__);
            }
        }
        $this->waypoints = $waypoints;
        return $this;
    }
    /**
     * Add item to waypoints value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_PointTO $item
     * @return \StructType\Api_GeofenceRouteTO
     */
    public function addToWaypoints(\StructType\Api_PointTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_PointTO) {
            throw new \InvalidArgumentException(sprintf('The waypoints property can only contain items of \StructType\Api_PointTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->waypoints[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_GeofenceRouteTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
