<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Api_GeofencePlusNotificationTO StructType
 * @subpackage Structs
 */
class Api_GeofencePlusNotificationTO extends AbstractStructBase
{
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $driverId;
    /**
     * The eventTime
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Date
     */
    public $eventTime;
    /**
     * The geofenceName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $geofenceName;
    /**
     * The geofencePlusId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $geofencePlusId;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Double
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Double
     */
    public $longitude;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The triggerType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $triggerType;
    /**
     * The vehicleInformationId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Api_Long
     */
    public $vehicleInformationId;
    /**
     * Constructor method for Api_GeofencePlusNotificationTO
     * @uses Api_GeofencePlusNotificationTO::setDriverId()
     * @uses Api_GeofencePlusNotificationTO::setEventTime()
     * @uses Api_GeofencePlusNotificationTO::setGeofenceName()
     * @uses Api_GeofencePlusNotificationTO::setGeofencePlusId()
     * @uses Api_GeofencePlusNotificationTO::setLatitude()
     * @uses Api_GeofencePlusNotificationTO::setLongitude()
     * @uses Api_GeofencePlusNotificationTO::setMessage()
     * @uses Api_GeofencePlusNotificationTO::setTriggerType()
     * @uses Api_GeofencePlusNotificationTO::setVehicleInformationId()
     * @param \StructType\Api_Long $driverId
     * @param \StructType\Api_Date $eventTime
     * @param string $geofenceName
     * @param \StructType\Api_Long $geofencePlusId
     * @param \StructType\Api_Double $latitude
     * @param \StructType\Api_Double $longitude
     * @param string $message
     * @param string $triggerType
     * @param \StructType\Api_Long $vehicleInformationId
     */
    public function __construct(\StructType\Api_Long $driverId = null, \StructType\Api_Date $eventTime = null, $geofenceName = null, \StructType\Api_Long $geofencePlusId = null, \StructType\Api_Double $latitude = null, \StructType\Api_Double $longitude = null, $message = null, $triggerType = null, \StructType\Api_Long $vehicleInformationId = null)
    {
        $this
            ->setDriverId($driverId)
            ->setEventTime($eventTime)
            ->setGeofenceName($geofenceName)
            ->setGeofencePlusId($geofencePlusId)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setMessage($message)
            ->setTriggerType($triggerType)
            ->setVehicleInformationId($vehicleInformationId);
    }
    /**
     * Get driverId value
     * @return \StructType\Api_Long|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param \StructType\Api_Long $driverId
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setDriverId(\StructType\Api_Long $driverId = null)
    {
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get eventTime value
     * @return \StructType\Api_Date|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param \StructType\Api_Date $eventTime
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setEventTime(\StructType\Api_Date $eventTime = null)
    {
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get geofenceName value
     * @return string|null
     */
    public function getGeofenceName()
    {
        return $this->geofenceName;
    }
    /**
     * Set geofenceName value
     * @param string $geofenceName
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setGeofenceName($geofenceName = null)
    {
        // validation for constraint: string
        if (!is_null($geofenceName) && !is_string($geofenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geofenceName)), __LINE__);
        }
        $this->geofenceName = $geofenceName;
        return $this;
    }
    /**
     * Get geofencePlusId value
     * @return \StructType\Api_Long|null
     */
    public function getGeofencePlusId()
    {
        return $this->geofencePlusId;
    }
    /**
     * Set geofencePlusId value
     * @param \StructType\Api_Long $geofencePlusId
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setGeofencePlusId(\StructType\Api_Long $geofencePlusId = null)
    {
        $this->geofencePlusId = $geofencePlusId;
        return $this;
    }
    /**
     * Get latitude value
     * @return \StructType\Api_Double|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param \StructType\Api_Double $latitude
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setLatitude(\StructType\Api_Double $latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return \StructType\Api_Double|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param \StructType\Api_Double $longitude
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setLongitude(\StructType\Api_Double $longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get triggerType value
     * @return string|null
     */
    public function getTriggerType()
    {
        return $this->triggerType;
    }
    /**
     * Set triggerType value
     * @param string $triggerType
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setTriggerType($triggerType = null)
    {
        // validation for constraint: string
        if (!is_null($triggerType) && !is_string($triggerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($triggerType)), __LINE__);
        }
        $this->triggerType = $triggerType;
        return $this;
    }
    /**
     * Get vehicleInformationId value
     * @return \StructType\Api_Long|null
     */
    public function getVehicleInformationId()
    {
        return $this->vehicleInformationId;
    }
    /**
     * Set vehicleInformationId value
     * @param \StructType\Api_Long $vehicleInformationId
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public function setVehicleInformationId(\StructType\Api_Long $vehicleInformationId = null)
    {
        $this->vehicleInformationId = $vehicleInformationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Api_GeofencePlusNotificationTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
