<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markOrderAsCompleted
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkOrderAsCompleted $parameters
     * @return \StructType\MarkOrderAsCompletedResponse|bool
     */
    public function markOrderAsCompleted(\StructType\MarkOrderAsCompleted $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->markOrderAsCompleted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markOrderAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkOrderAsRead $parameters
     * @return \StructType\MarkOrderAsReadResponse|bool
     */
    public function markOrderAsRead(\StructType\MarkOrderAsRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->markOrderAsRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarkOrderAsCompletedResponse|\StructType\MarkOrderAsReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
