<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_VehicleInfoArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_VehicleInfoArrayTO extends AbstractStructArrayBase
{
    /**
     * The vehicleInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_VehicleInfoTO[]
     */
    public $vehicleInfos;
    /**
     * Constructor method for Api_VehicleInfoArrayTO
     * @uses Api_VehicleInfoArrayTO::setVehicleInfos()
     * @param \StructType\Api_VehicleInfoTO[] $vehicleInfos
     */
    public function __construct(array $vehicleInfos = array())
    {
        $this
            ->setVehicleInfos($vehicleInfos);
    }
    /**
     * Get vehicleInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_VehicleInfoTO[]|null
     */
    public function getVehicleInfos()
    {
        return isset($this->vehicleInfos) ? $this->vehicleInfos : null;
    }
    /**
     * Set vehicleInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleInfoTO[] $vehicleInfos
     * @return \ArrayType\Api_VehicleInfoArrayTO
     */
    public function setVehicleInfos(array $vehicleInfos = array())
    {
        foreach ($vehicleInfos as $api_VehicleInfoArrayTOVehicleInfosItem) {
            // validation for constraint: itemType
            if (!$api_VehicleInfoArrayTOVehicleInfosItem instanceof \StructType\Api_VehicleInfoTO) {
                throw new \InvalidArgumentException(sprintf('The vehicleInfos property can only contain items of \StructType\Api_VehicleInfoTO, "%s" given', is_object($api_VehicleInfoArrayTOVehicleInfosItem) ? get_class($api_VehicleInfoArrayTOVehicleInfosItem) : gettype($api_VehicleInfoArrayTOVehicleInfosItem)), __LINE__);
            }
        }
        if (is_null($vehicleInfos) || (is_array($vehicleInfos) && empty($vehicleInfos))) {
            unset($this->vehicleInfos);
        } else {
            $this->vehicleInfos = $vehicleInfos;
        }
        return $this;
    }
    /**
     * Add item to vehicleInfos value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleInfoTO $item
     * @return \ArrayType\Api_VehicleInfoArrayTO
     */
    public function addToVehicleInfos(\StructType\Api_VehicleInfoTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_VehicleInfoTO) {
            throw new \InvalidArgumentException(sprintf('The vehicleInfos property can only contain items of \StructType\Api_VehicleInfoTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vehicleInfos[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_VehicleInfoTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_VehicleInfoTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_VehicleInfoTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_VehicleInfoTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_VehicleInfoTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string vehicleInfos
     */
    public function getAttributeName()
    {
        return 'vehicleInfos';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_VehicleInfoArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
