<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_VehicleArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_VehicleArrayTO extends AbstractStructArrayBase
{
    /**
     * The vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_VehicleTO[]
     */
    public $vehicles;
    /**
     * Constructor method for Api_VehicleArrayTO
     * @uses Api_VehicleArrayTO::setVehicles()
     * @param \StructType\Api_VehicleTO[] $vehicles
     */
    public function __construct(array $vehicles = array())
    {
        $this
            ->setVehicles($vehicles);
    }
    /**
     * Get vehicles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_VehicleTO[]|null
     */
    public function getVehicles()
    {
        return isset($this->vehicles) ? $this->vehicles : null;
    }
    /**
     * Set vehicles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleTO[] $vehicles
     * @return \ArrayType\Api_VehicleArrayTO
     */
    public function setVehicles(array $vehicles = array())
    {
        foreach ($vehicles as $api_VehicleArrayTOVehiclesItem) {
            // validation for constraint: itemType
            if (!$api_VehicleArrayTOVehiclesItem instanceof \StructType\Api_VehicleTO) {
                throw new \InvalidArgumentException(sprintf('The vehicles property can only contain items of \StructType\Api_VehicleTO, "%s" given', is_object($api_VehicleArrayTOVehiclesItem) ? get_class($api_VehicleArrayTOVehiclesItem) : gettype($api_VehicleArrayTOVehiclesItem)), __LINE__);
            }
        }
        if (is_null($vehicles) || (is_array($vehicles) && empty($vehicles))) {
            unset($this->vehicles);
        } else {
            $this->vehicles = $vehicles;
        }
        return $this;
    }
    /**
     * Add item to vehicles value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_VehicleTO $item
     * @return \ArrayType\Api_VehicleArrayTO
     */
    public function addToVehicles(\StructType\Api_VehicleTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_VehicleTO) {
            throw new \InvalidArgumentException(sprintf('The vehicles property can only contain items of \StructType\Api_VehicleTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vehicles[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_VehicleTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_VehicleTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_VehicleTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_VehicleTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_VehicleTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string vehicles
     */
    public function getAttributeName()
    {
        return 'vehicles';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_VehicleArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
