<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_GeofencePlusDetailsArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_GeofencePlusDetailsArrayTO extends AbstractStructArrayBase
{
    /**
     * The geofences
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_GeofencePlusDetailsTO[]
     */
    public $geofences;
    /**
     * Constructor method for Api_GeofencePlusDetailsArrayTO
     * @uses Api_GeofencePlusDetailsArrayTO::setGeofences()
     * @param \StructType\Api_GeofencePlusDetailsTO[] $geofences
     */
    public function __construct(array $geofences = array())
    {
        $this
            ->setGeofences($geofences);
    }
    /**
     * Get geofences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_GeofencePlusDetailsTO[]|null
     */
    public function getGeofences()
    {
        return isset($this->geofences) ? $this->geofences : null;
    }
    /**
     * Set geofences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_GeofencePlusDetailsTO[] $geofences
     * @return \ArrayType\Api_GeofencePlusDetailsArrayTO
     */
    public function setGeofences(array $geofences = array())
    {
        foreach ($geofences as $api_GeofencePlusDetailsArrayTOGeofencesItem) {
            // validation for constraint: itemType
            if (!$api_GeofencePlusDetailsArrayTOGeofencesItem instanceof \StructType\Api_GeofencePlusDetailsTO) {
                throw new \InvalidArgumentException(sprintf('The geofences property can only contain items of \StructType\Api_GeofencePlusDetailsTO, "%s" given', is_object($api_GeofencePlusDetailsArrayTOGeofencesItem) ? get_class($api_GeofencePlusDetailsArrayTOGeofencesItem) : gettype($api_GeofencePlusDetailsArrayTOGeofencesItem)), __LINE__);
            }
        }
        if (is_null($geofences) || (is_array($geofences) && empty($geofences))) {
            unset($this->geofences);
        } else {
            $this->geofences = $geofences;
        }
        return $this;
    }
    /**
     * Add item to geofences value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_GeofencePlusDetailsTO $item
     * @return \ArrayType\Api_GeofencePlusDetailsArrayTO
     */
    public function addToGeofences(\StructType\Api_GeofencePlusDetailsTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_GeofencePlusDetailsTO) {
            throw new \InvalidArgumentException(sprintf('The geofences property can only contain items of \StructType\Api_GeofencePlusDetailsTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->geofences[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_GeofencePlusDetailsTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_GeofencePlusDetailsTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_GeofencePlusDetailsTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_GeofencePlusDetailsTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_GeofencePlusDetailsTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string geofences
     */
    public function getAttributeName()
    {
        return 'geofences';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_GeofencePlusDetailsArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
