<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for Api_DriverArrayTO ArrayType
 * @subpackage Arrays
 */
class Api_DriverArrayTO extends AbstractStructArrayBase
{
    /**
     * The drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Api_DriverTO[]
     */
    public $drivers;
    /**
     * Constructor method for Api_DriverArrayTO
     * @uses Api_DriverArrayTO::setDrivers()
     * @param \StructType\Api_DriverTO[] $drivers
     */
    public function __construct(array $drivers = array())
    {
        $this
            ->setDrivers($drivers);
    }
    /**
     * Get drivers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Api_DriverTO[]|null
     */
    public function getDrivers()
    {
        return isset($this->drivers) ? $this->drivers : null;
    }
    /**
     * Set drivers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverTO[] $drivers
     * @return \ArrayType\Api_DriverArrayTO
     */
    public function setDrivers(array $drivers = array())
    {
        foreach ($drivers as $api_DriverArrayTODriversItem) {
            // validation for constraint: itemType
            if (!$api_DriverArrayTODriversItem instanceof \StructType\Api_DriverTO) {
                throw new \InvalidArgumentException(sprintf('The drivers property can only contain items of \StructType\Api_DriverTO, "%s" given', is_object($api_DriverArrayTODriversItem) ? get_class($api_DriverArrayTODriversItem) : gettype($api_DriverArrayTODriversItem)), __LINE__);
            }
        }
        if (is_null($drivers) || (is_array($drivers) && empty($drivers))) {
            unset($this->drivers);
        } else {
            $this->drivers = $drivers;
        }
        return $this;
    }
    /**
     * Add item to drivers value
     * @throws \InvalidArgumentException
     * @param \StructType\Api_DriverTO $item
     * @return \ArrayType\Api_DriverArrayTO
     */
    public function addToDrivers(\StructType\Api_DriverTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Api_DriverTO) {
            throw new \InvalidArgumentException(sprintf('The drivers property can only contain items of \StructType\Api_DriverTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->drivers[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Api_DriverTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Api_DriverTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Api_DriverTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Api_DriverTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Api_DriverTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string drivers
     */
    public function getAttributeName()
    {
        return 'drivers';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\Api_DriverArrayTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
