<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Authorize ServiceType
 */
$authorize = new \ServiceType\Authorize($options);
$authorize->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for Authorize operation/method
 */
if ($authorize->Authorize(new \StructType\AuthorizeRequest()) !== false) {
    print_r($authorize->getResult());
} else {
    print_r($authorize->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \ServiceType\Start($options);
$start->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for StartTransaction operation/method
 */
if ($start->StartTransaction(new \StructType\StartTransactionRequest()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Stop ServiceType
 */
$stop = new \ServiceType\Stop($options);
$stop->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for StopTransaction operation/method
 */
if ($stop->StopTransaction(new \StructType\StopTransactionRequest()) !== false) {
    print_r($stop->getResult());
} else {
    print_r($stop->getLastError());
}
/**
 * Samples for Heartbeat ServiceType
 */
$heartbeat = new \ServiceType\Heartbeat($options);
$heartbeat->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for Heartbeat operation/method
 */
if ($heartbeat->Heartbeat(new \StructType\HeartbeatRequest()) !== false) {
    print_r($heartbeat->getResult());
} else {
    print_r($heartbeat->getLastError());
}
/**
 * Samples for Meter ServiceType
 */
$meter = new \ServiceType\Meter($options);
$meter->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for MeterValues operation/method
 */
if ($meter->MeterValues(new \StructType\MeterValuesRequest()) !== false) {
    print_r($meter->getResult());
} else {
    print_r($meter->getLastError());
}
/**
 * Samples for Boot ServiceType
 */
$boot = new \ServiceType\Boot($options);
$boot->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for BootNotification operation/method
 */
if ($boot->BootNotification(new \StructType\BootNotificationRequest()) !== false) {
    print_r($boot->getResult());
} else {
    print_r($boot->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \ServiceType\Status($options);
$status->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for StatusNotification operation/method
 */
if ($status->StatusNotification(new \StructType\StatusNotificationRequest()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Firmware ServiceType
 */
$firmware = new \ServiceType\Firmware($options);
$firmware->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for FirmwareStatusNotification operation/method
 */
if ($firmware->FirmwareStatusNotification(new \StructType\FirmwareStatusNotificationRequest()) !== false) {
    print_r($firmware->getResult());
} else {
    print_r($firmware->getLastError());
}
/**
 * Samples for Diagnostics ServiceType
 */
$diagnostics = new \ServiceType\Diagnostics($options);
$diagnostics->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for DiagnosticsStatusNotification operation/method
 */
if ($diagnostics->DiagnosticsStatusNotification(new \StructType\DiagnosticsStatusNotificationRequest()) !== false) {
    print_r($diagnostics->getResult());
} else {
    print_r($diagnostics->getLastError());
}
/**
 * Samples for Data ServiceType
 */
$data = new \ServiceType\Data($options);
$data->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for DataTransfer operation/method
 */
if ($data->DataTransfer(new \StructType\DataTransferRequest()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
