<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopTransactionRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the StopTransaction.req PDU
 * @subpackage Structs
 */
class StopTransactionRequest extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $transactionId;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timestamp;
    /**
     * The meterStop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $meterStop;
    /**
     * The idTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $idTag;
    /**
     * The transactionData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TransactionData[]
     */
    public $transactionData;
    /**
     * Constructor method for StopTransactionRequest
     * @uses StopTransactionRequest::setTransactionId()
     * @uses StopTransactionRequest::setTimestamp()
     * @uses StopTransactionRequest::setMeterStop()
     * @uses StopTransactionRequest::setIdTag()
     * @uses StopTransactionRequest::setTransactionData()
     * @param int $transactionId
     * @param string $timestamp
     * @param int $meterStop
     * @param string $idTag
     * @param \StructType\TransactionData[] $transactionData
     */
    public function __construct($transactionId = null, $timestamp = null, $meterStop = null, $idTag = null, array $transactionData = array())
    {
        $this
            ->setTransactionId($transactionId)
            ->setTimestamp($timestamp)
            ->setMeterStop($meterStop)
            ->setIdTag($idTag)
            ->setTransactionData($transactionData);
    }
    /**
     * Get transactionId value
     * @return int
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\StopTransactionRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !is_numeric($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\StopTransactionRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get meterStop value
     * @return int
     */
    public function getMeterStop()
    {
        return $this->meterStop;
    }
    /**
     * Set meterStop value
     * @param int $meterStop
     * @return \StructType\StopTransactionRequest
     */
    public function setMeterStop($meterStop = null)
    {
        // validation for constraint: int
        if (!is_null($meterStop) && !is_numeric($meterStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStop)), __LINE__);
        }
        $this->meterStop = $meterStop;
        return $this;
    }
    /**
     * Get idTag value
     * @return string|null
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\StopTransactionRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idTag) && strlen($idTag) > 20) || (is_array($idTag) && count($idTag) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($idTag) ? strlen($idTag) : count($idTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get transactionData value
     * @return \StructType\TransactionData[]|null
     */
    public function getTransactionData()
    {
        return $this->transactionData;
    }
    /**
     * Set transactionData value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionData[] $transactionData
     * @return \StructType\StopTransactionRequest
     */
    public function setTransactionData(array $transactionData = array())
    {
        foreach ($transactionData as $stopTransactionRequestTransactionDataItem) {
            // validation for constraint: itemType
            if (!$stopTransactionRequestTransactionDataItem instanceof \StructType\TransactionData) {
                throw new \InvalidArgumentException(sprintf('The transactionData property can only contain items of \StructType\TransactionData, "%s" given', is_object($stopTransactionRequestTransactionDataItem) ? get_class($stopTransactionRequestTransactionDataItem) : gettype($stopTransactionRequestTransactionDataItem)), __LINE__);
            }
        }
        $this->transactionData = $transactionData;
        return $this;
    }
    /**
     * Add item to transactionData value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionData $item
     * @return \StructType\StopTransactionRequest
     */
    public function addToTransactionData(\StructType\TransactionData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionData) {
            throw new \InvalidArgumentException(sprintf('The transactionData property can only contain items of \StructType\TransactionData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->transactionData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
