<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartTransactionRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the StartTransaction.req PDU
 * @subpackage Structs
 */
class StartTransactionRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The idTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $idTag;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timestamp;
    /**
     * The meterStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $meterStart;
    /**
     * The reservationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $reservationId;
    /**
     * Constructor method for StartTransactionRequest
     * @uses StartTransactionRequest::setConnectorId()
     * @uses StartTransactionRequest::setIdTag()
     * @uses StartTransactionRequest::setTimestamp()
     * @uses StartTransactionRequest::setMeterStart()
     * @uses StartTransactionRequest::setReservationId()
     * @param int $connectorId
     * @param string $idTag
     * @param string $timestamp
     * @param int $meterStart
     * @param int $reservationId
     */
    public function __construct($connectorId = null, $idTag = null, $timestamp = null, $meterStart = null, $reservationId = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setIdTag($idTag)
            ->setTimestamp($timestamp)
            ->setMeterStart($meterStart)
            ->setReservationId($reservationId);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\StartTransactionRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !is_numeric($connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get idTag value
     * @return string
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\StartTransactionRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idTag) && strlen($idTag) > 20) || (is_array($idTag) && count($idTag) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($idTag) ? strlen($idTag) : count($idTag)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\StartTransactionRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get meterStart value
     * @return int
     */
    public function getMeterStart()
    {
        return $this->meterStart;
    }
    /**
     * Set meterStart value
     * @param int $meterStart
     * @return \StructType\StartTransactionRequest
     */
    public function setMeterStart($meterStart = null)
    {
        // validation for constraint: int
        if (!is_null($meterStart) && !is_numeric($meterStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStart)), __LINE__);
        }
        $this->meterStart = $meterStart;
        return $this;
    }
    /**
     * Get reservationId value
     * @return int|null
     */
    public function getReservationId()
    {
        return $this->reservationId;
    }
    /**
     * Set reservationId value
     * @param int $reservationId
     * @return \StructType\StartTransactionRequest
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationId) && !is_numeric($reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationId)), __LINE__);
        }
        $this->reservationId = $reservationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
