<?php

namespace EnumType;

/**
 * This class stands for ReadingContext EnumType
 * @subpackage Enumerations
 */
class ReadingContext
{
    /**
     * Constant for value 'Interruption.Begin'
     * @return string 'Interruption.Begin'
     */
    const VALUE_INTERRUPTION_BEGIN = 'Interruption.Begin';
    /**
     * Constant for value 'Interruption.End'
     * @return string 'Interruption.End'
     */
    const VALUE_INTERRUPTION_END = 'Interruption.End';
    /**
     * Constant for value 'Sample.Clock'
     * @return string 'Sample.Clock'
     */
    const VALUE_SAMPLE_CLOCK = 'Sample.Clock';
    /**
     * Constant for value 'Sample.Periodic'
     * @return string 'Sample.Periodic'
     */
    const VALUE_SAMPLE_PERIODIC = 'Sample.Periodic';
    /**
     * Constant for value 'Transaction.Begin'
     * @return string 'Transaction.Begin'
     */
    const VALUE_TRANSACTION_BEGIN = 'Transaction.Begin';
    /**
     * Constant for value 'Transaction.End'
     * @return string 'Transaction.End'
     */
    const VALUE_TRANSACTION_END = 'Transaction.End';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERRUPTION_BEGIN
     * @uses self::VALUE_INTERRUPTION_END
     * @uses self::VALUE_SAMPLE_CLOCK
     * @uses self::VALUE_SAMPLE_PERIODIC
     * @uses self::VALUE_TRANSACTION_BEGIN
     * @uses self::VALUE_TRANSACTION_END
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERRUPTION_BEGIN,
            self::VALUE_INTERRUPTION_END,
            self::VALUE_SAMPLE_CLOCK,
            self::VALUE_SAMPLE_PERIODIC,
            self::VALUE_TRANSACTION_BEGIN,
            self::VALUE_TRANSACTION_END,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
