<?php

namespace EnumType;

/**
 * This class stands for Location EnumType
 * @subpackage Enumerations
 */
class Location
{
    /**
     * Constant for value 'Inlet'
     * @return string 'Inlet'
     */
    const VALUE_INLET = 'Inlet';
    /**
     * Constant for value 'Outlet'
     * @return string 'Outlet'
     */
    const VALUE_OUTLET = 'Outlet';
    /**
     * Constant for value 'Body'
     * @return string 'Body'
     */
    const VALUE_BODY = 'Body';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INLET
     * @uses self::VALUE_OUTLET
     * @uses self::VALUE_BODY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INLET,
            self::VALUE_OUTLET,
            self::VALUE_BODY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
