<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiagnosticsStatusNotificationRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the DiagnosticsStatusNotification.req PDU
 * @subpackage Structs
 */
class DiagnosticsStatusNotificationRequest extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * Constructor method for DiagnosticsStatusNotificationRequest
     * @uses DiagnosticsStatusNotificationRequest::setStatus()
     * @param string $status
     */
    public function __construct($status = null)
    {
        $this
            ->setStatus($status);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\DiagnosticsStatus::valueIsValid()
     * @uses \EnumType\DiagnosticsStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DiagnosticsStatusNotificationRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DiagnosticsStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\DiagnosticsStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiagnosticsStatusNotificationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
