<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BootNotificationRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines the BootNotification.req PDU
 * @subpackage Structs
 */
class BootNotificationRequest extends AbstractStructBase
{
    /**
     * The chargePointVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: String type of max 20 chars that is to be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $chargePointVendor;
    /**
     * The chargePointModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: String type of max 20 chars that is to be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $chargePointModel;
    /**
     * The chargePointSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 25 chars that is to be treated as case insensitive.
     * - maxLength: 25
     * @var string
     */
    public $chargePointSerialNumber;
    /**
     * The chargeBoxSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 25 chars that is to be treated as case insensitive.
     * - maxLength: 25
     * @var string
     */
    public $chargeBoxSerialNumber;
    /**
     * The firmwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 50 chars that is to be treated as case insensitive.
     * - maxLength: 50
     * @var string
     */
    public $firmwareVersion;
    /**
     * The iccid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 20 chars that is to be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $iccid;
    /**
     * The imsi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 20 chars that is to be treated as case insensitive.
     * - maxLength: 20
     * @var string
     */
    public $imsi;
    /**
     * The meterType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 25 chars that is to be treated as case insensitive.
     * - maxLength: 25
     * @var string
     */
    public $meterType;
    /**
     * The meterSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: String type of max 25 chars that is to be treated as case insensitive.
     * - maxLength: 25
     * @var string
     */
    public $meterSerialNumber;
    /**
     * Constructor method for BootNotificationRequest
     * @uses BootNotificationRequest::setChargePointVendor()
     * @uses BootNotificationRequest::setChargePointModel()
     * @uses BootNotificationRequest::setChargePointSerialNumber()
     * @uses BootNotificationRequest::setChargeBoxSerialNumber()
     * @uses BootNotificationRequest::setFirmwareVersion()
     * @uses BootNotificationRequest::setIccid()
     * @uses BootNotificationRequest::setImsi()
     * @uses BootNotificationRequest::setMeterType()
     * @uses BootNotificationRequest::setMeterSerialNumber()
     * @param string $chargePointVendor
     * @param string $chargePointModel
     * @param string $chargePointSerialNumber
     * @param string $chargeBoxSerialNumber
     * @param string $firmwareVersion
     * @param string $iccid
     * @param string $imsi
     * @param string $meterType
     * @param string $meterSerialNumber
     */
    public function __construct($chargePointVendor = null, $chargePointModel = null, $chargePointSerialNumber = null, $chargeBoxSerialNumber = null, $firmwareVersion = null, $iccid = null, $imsi = null, $meterType = null, $meterSerialNumber = null)
    {
        $this
            ->setChargePointVendor($chargePointVendor)
            ->setChargePointModel($chargePointModel)
            ->setChargePointSerialNumber($chargePointSerialNumber)
            ->setChargeBoxSerialNumber($chargeBoxSerialNumber)
            ->setFirmwareVersion($firmwareVersion)
            ->setIccid($iccid)
            ->setImsi($imsi)
            ->setMeterType($meterType)
            ->setMeterSerialNumber($meterSerialNumber);
    }
    /**
     * Get chargePointVendor value
     * @return string
     */
    public function getChargePointVendor()
    {
        return $this->chargePointVendor;
    }
    /**
     * Set chargePointVendor value
     * @param string $chargePointVendor
     * @return \StructType\BootNotificationRequest
     */
    public function setChargePointVendor($chargePointVendor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargePointVendor) && strlen($chargePointVendor) > 20) || (is_array($chargePointVendor) && count($chargePointVendor) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($chargePointVendor) ? strlen($chargePointVendor) : count($chargePointVendor)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargePointVendor) && !is_string($chargePointVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargePointVendor)), __LINE__);
        }
        $this->chargePointVendor = $chargePointVendor;
        return $this;
    }
    /**
     * Get chargePointModel value
     * @return string
     */
    public function getChargePointModel()
    {
        return $this->chargePointModel;
    }
    /**
     * Set chargePointModel value
     * @param string $chargePointModel
     * @return \StructType\BootNotificationRequest
     */
    public function setChargePointModel($chargePointModel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargePointModel) && strlen($chargePointModel) > 20) || (is_array($chargePointModel) && count($chargePointModel) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($chargePointModel) ? strlen($chargePointModel) : count($chargePointModel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargePointModel) && !is_string($chargePointModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargePointModel)), __LINE__);
        }
        $this->chargePointModel = $chargePointModel;
        return $this;
    }
    /**
     * Get chargePointSerialNumber value
     * @return string|null
     */
    public function getChargePointSerialNumber()
    {
        return $this->chargePointSerialNumber;
    }
    /**
     * Set chargePointSerialNumber value
     * @param string $chargePointSerialNumber
     * @return \StructType\BootNotificationRequest
     */
    public function setChargePointSerialNumber($chargePointSerialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargePointSerialNumber) && strlen($chargePointSerialNumber) > 25) || (is_array($chargePointSerialNumber) && count($chargePointSerialNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($chargePointSerialNumber) ? strlen($chargePointSerialNumber) : count($chargePointSerialNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargePointSerialNumber) && !is_string($chargePointSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargePointSerialNumber)), __LINE__);
        }
        $this->chargePointSerialNumber = $chargePointSerialNumber;
        return $this;
    }
    /**
     * Get chargeBoxSerialNumber value
     * @return string|null
     */
    public function getChargeBoxSerialNumber()
    {
        return $this->chargeBoxSerialNumber;
    }
    /**
     * Set chargeBoxSerialNumber value
     * @param string $chargeBoxSerialNumber
     * @return \StructType\BootNotificationRequest
     */
    public function setChargeBoxSerialNumber($chargeBoxSerialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargeBoxSerialNumber) && strlen($chargeBoxSerialNumber) > 25) || (is_array($chargeBoxSerialNumber) && count($chargeBoxSerialNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($chargeBoxSerialNumber) ? strlen($chargeBoxSerialNumber) : count($chargeBoxSerialNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargeBoxSerialNumber) && !is_string($chargeBoxSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeBoxSerialNumber)), __LINE__);
        }
        $this->chargeBoxSerialNumber = $chargeBoxSerialNumber;
        return $this;
    }
    /**
     * Get firmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->firmwareVersion;
    }
    /**
     * Set firmwareVersion value
     * @param string $firmwareVersion
     * @return \StructType\BootNotificationRequest
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firmwareVersion) && strlen($firmwareVersion) > 50) || (is_array($firmwareVersion) && count($firmwareVersion) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($firmwareVersion) ? strlen($firmwareVersion) : count($firmwareVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firmwareVersion)), __LINE__);
        }
        $this->firmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get iccid value
     * @return string|null
     */
    public function getIccid()
    {
        return $this->iccid;
    }
    /**
     * Set iccid value
     * @param string $iccid
     * @return \StructType\BootNotificationRequest
     */
    public function setIccid($iccid = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iccid) && strlen($iccid) > 20) || (is_array($iccid) && count($iccid) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($iccid) ? strlen($iccid) : count($iccid)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iccid) && !is_string($iccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iccid)), __LINE__);
        }
        $this->iccid = $iccid;
        return $this;
    }
    /**
     * Get imsi value
     * @return string|null
     */
    public function getImsi()
    {
        return $this->imsi;
    }
    /**
     * Set imsi value
     * @param string $imsi
     * @return \StructType\BootNotificationRequest
     */
    public function setImsi($imsi = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($imsi) && strlen($imsi) > 20) || (is_array($imsi) && count($imsi) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($imsi) ? strlen($imsi) : count($imsi)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imsi) && !is_string($imsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imsi)), __LINE__);
        }
        $this->imsi = $imsi;
        return $this;
    }
    /**
     * Get meterType value
     * @return string|null
     */
    public function getMeterType()
    {
        return $this->meterType;
    }
    /**
     * Set meterType value
     * @param string $meterType
     * @return \StructType\BootNotificationRequest
     */
    public function setMeterType($meterType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($meterType) && strlen($meterType) > 25) || (is_array($meterType) && count($meterType) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($meterType) ? strlen($meterType) : count($meterType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meterType) && !is_string($meterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterType)), __LINE__);
        }
        $this->meterType = $meterType;
        return $this;
    }
    /**
     * Get meterSerialNumber value
     * @return string|null
     */
    public function getMeterSerialNumber()
    {
        return $this->meterSerialNumber;
    }
    /**
     * Set meterSerialNumber value
     * @param string $meterSerialNumber
     * @return \StructType\BootNotificationRequest
     */
    public function setMeterSerialNumber($meterSerialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($meterSerialNumber) && strlen($meterSerialNumber) > 25) || (is_array($meterSerialNumber) && count($meterSerialNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($meterSerialNumber) ? strlen($meterSerialNumber) : count($meterSerialNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meterSerialNumber) && !is_string($meterSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterSerialNumber)), __LINE__);
        }
        $this->meterSerialNumber = $meterSerialNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BootNotificationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
