<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authorize ServiceType
 * @subpackage Services
 */
class Authorize extends AbstractSoapClientBase
{
    /**
     * Sets the ChargeBoxIdentity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $chargeBoxIdentity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderChargeBoxIdentity($chargeBoxIdentity, $nameSpace = 'urn://Ocpp/Cs/2012/06/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'chargeBoxIdentity', $chargeBoxIdentity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Authorize
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cs/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizeRequest $parameters
     * @return \StructType\AuthorizeResponse|bool
     */
    public function Authorize(\StructType\AuthorizeRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Authorize($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthorizeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
